<?php

	use Installation\ParsedInitialPage;
	use System\ContentHelper;

	/** @var array{parsedInitialPages: ParsedInitialPage[]} $viewScope */
	$initialPages = $viewScope['parsedInitialPages'];
?>
@Layout = "backend-install.php"
@Head{
	<title>Installation - Uplift CMS</title>
	<script type="module" src="/uplift-assets/js/installer/Installer.js"></script>
}
@Body{
	<installation>
		<div class="main-content">
			<?php include __DIR__ . "/partials/_error.html" ?>
			<?php include __DIR__ . "/partials/_loading.html" ?>
			<?php include __DIR__ . "/partials/_complete.html" ?>

			<div id="installation-form-container" class="card">
				<div class="card-header">
					<h4>Install Uplift Core</h4>
				</div>
				<div class="card-body">
					<p>
						This process will walk you through the initial settings for the Uplift CMS installation. If you will be installing Uplift to development features for or test features, please use the "Mark as a test build" checkbox below the purple MySQL alert box.
					</p>
					<p>
						<span class="text-danger">*</span> = Required field
					</p>
					<div class="my-3">
						<div class="alert alert-info">
							<h4>MySQL Installation Schema</h4>
							<p>
								From your Nox environment file, Uplift will install all necessary tables into the <strong><?= NoxEnv::MYSQL_DB_NAME ?></strong> database schema.
							</p>
						</div>
					</div>
					<form id="installation-form">
						<section class="my-3">
							<div class="form-check form-switch">
								<input class="form-check-input" type="checkbox" role="switch" name="is-test-build" id="is-test-build-input">
								<label class="form-check-label" for="is-test-build-input">Mark this build as a test-only or development-only build.</label>
							</div>
						</section>
						<section class="card">
							<div class="card-header">
								<h5>Company Information</h5>
							</div>
							<div class="card-body">
								<div class="mb-3">
									<label for="schema-type">Schema Type</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-card-list"></i></div>
										<input id="schema-type" list="schema-list" autocomplete="off" type="text" name="schema-type" class="form-control">
									</div>
									<datalist id="schema-list">
										<?php include __DIR__ . "/../_partials/schema-data-list.html" ?>
									</datalist>
								</div>
								<div class="mb-2">
									<label for="company-accelo-id-input"><span class="text-danger">*</span> Accelo Company ID</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-person-lines-fill"></i></div>
										<input id="company-accelo-id-input" autocomplete="off" type="text" name="company-accelo-id" class="form-control">
									</div>
								</div>
								<div class="mb-2">
									<label for="company-name"><span class="text-danger">*</span> Company Name</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-textarea-t"></i></div>
										<input id="company-name" autocomplete="off" type="text" name="company-name" class="form-control">
									</div>
								</div>
								<div class="mb-2">
									<label for="company-street">Company Street</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-geo-alt-fill"></i></div>
										<input id="company-street" autocomplete="off" type="text" name="company-street" class="form-control" value="">
									</div>
								</div>
								<div class="mb-2">
									<label for="company-city">Company City</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-geo-alt-fill"></i></div>
										<input id="company-city" autocomplete="off" type="text" name="company-city" class="form-control" value="">
									</div>
								</div>
								<div class="row mb-2">
									<div class="col-6">
										<div>
											<label for="company-state">Company State (abbr.)</label>
											<div class="input-group">
												<div class="input-group-text"><i class="bi bi-geo-alt-fill"></i></div>
												<input id="company-state" autocomplete="off" type="text" name="company-state" class="form-control" value="">
											</div>
										</div>
									</div>
									<div class="col-6">
										<div>
											<label for="company-postal">Company Postal</label>
											<div class="input-group">
												<div class="input-group-text"><i class="bi bi-geo-alt-fill"></i></div>
												<input id="company-postal" autocomplete="off" type="text" name="company-postal" class="form-control" value="">
											</div>
										</div>
									</div>
								</div>
								<div class="row mb-3">
									<div class="col-xl-6">
										<div>
											<label for="company-phone-number-input">Primary company phone number</label>
											<div class="input-group">
												<div class="input-group-text"><i class="bi bi-telephone-fill"></i></div>
												<input id="company-phone-number-input" autocomplete="off" type="text" name="company-phone-number" class="form-control" value="">
											</div>
										</div>
									</div>
									<div class="col-xl-6">
										<div>
											<label for="company-fax-number-input">Company fax number</label>
											<div class="input-group">
												<div class="input-group-text"><i class="bi bi-printer-fill"></i></div>
												<input id="company-fax-number-input" autocomplete="off" type="text" name="company-fax-number" class="form-control" value="">
											</div>
										</div>
									</div>
									<div class="col-12">
										<small>You can add more phone numbers or fax numbers in the system settings after installation.</small>
									</div>
								</div>
								<div class="row align-items-center">
									<div class="col-6">
										<div>
											<span>Company Logo</span>
											<div class="d-flex align-items-center">
												<img width="70" height="70" class="border me-3" id="logo-preview" alt="">
												<label for="company-logo-input" class="btn btn-primary btn-sm set-preview">
													<i class="bi bi-upload"></i>
													<span>Upload Image</span>
												</label>
												<input id="company-logo-input" class="d-none" type="file" name="company-logo">
											</div>
										</div>
									</div>
									<div class="col-6">
										<div>
											<span>Company Favicon</span>
											<div class="d-flex align-items-center">
												<img width="32" height="32" class="border me-3" id="favicon-preview" alt="">
												<label for="company-favicon-input" class="btn btn-primary btn-sm set-preview">
													<i class="bi bi-upload"></i>
													<span>Upload Image</span>
												</label>
												<input id="company-favicon-input" class="d-none" type="file" name="company-favicon">
											</div>
										</div>
									</div>
								</div>
							</div>
						</section>
						<section class="card mt-3">
							<div class="card-header">
								<h5>Default CMS Account Setup</h5>
							</div>
							<div class="card-body">
								<div class="mb-2">
									<label for="master-account-username-input"><span class="text-danger">*</span> Master account username</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-person-circle"></i></div>
										<input id="master-account-username-input" autocomplete="off" type="text" name="master-account-username" class="form-control" value="<?= ContentHelper::generateGibberish(22); ?>">
									</div>
									<small>We autogenerate a lengthy, gibberish username for you to keep it random and harder for attackers to guess.</small>
								</div>
								<div class="mb-2">
									<div class="container-fluid p-0">
										<div class="row">
											<div class="col-xl-6">
												<label for="master-account-first-name-input"><span class="text-danger">*</span> Master account first name</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-person-circle"></i></div>
													<input id="master-account-first-name-input" autocomplete="off" type="text" name="master-account-first-name" class="form-control" value="Master">
												</div>
											</div>
											<div class="col-xl-6">
												<label for="master-account-last-name-input"><span class="text-danger">*</span> Master account last name</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-person-circle"></i></div>
													<input id="master-account-last-name-input" autocomplete="off" type="text" name="master-account-last-name" class="form-control" value="Account">
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="mb-2">
									<label for="master-account-password-input"><span class="text-danger">*</span> Master account password</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-key-fill"></i></div>
										<input readonly id="master-account-password-input" autocomplete="off" type="text" name="master-account-password" class="form-control" value="<?= ContentHelper::generateGibberish(42, ContentHelper::DEFAULT_GIBBERISH_CHARACTERS . "____"); ?>">
									</div>
									<small>This is an autogenerated, 42-character password. You cannot change this during installation.</small>
								</div>
								<hr>
								<div class="mb-2">
									<small>Additionally, a set of client credentials will be generated. This is for client logins to the project form - access at the route of <code>/ipp-form</code>. This account will only have permission for that form.</small>
									<div class="container-fluid p-0">
										<div class="row">
											<div class="col-xl-6">
												<label for="client-account-first-name-input"><span class="text-danger">*</span> Client account first name</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-person-circle"></i></div>
													<input id="client-account-first-name-input" readonly autocomplete="off" type="text" name="client-account-first-name" class="form-control" value="Client">
												</div>
											</div>
											<div class="col-xl-6">
												<label for="client-account-last-name-input"><span class="text-danger">*</span> Client account last name</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-person-circle"></i></div>
													<input id="client-account-last-name-input" readonly autocomplete="off" type="text" name="client-account-last-name" class="form-control" value="Account">
												</div>
											</div>
										</div>
										<div class="row mt-2">
											<div class="col-xl-6">
												<label for="client-account-username-input"><span class="text-danger">*</span> Client account username</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-person-circle"></i></div>
													<input id="client-account-username-input" readonly autocomplete="off" type="text" name="client-account-username" class="form-control" value="client">
												</div>
											</div>
											<div class="col-xl-6">
												<label for="client-account-password-input"><span class="text-danger">*</span> Client account password</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-person-circle"></i></div>
													<input id="client-account-password-input" readonly autocomplete="off" type="text" name="client-account-password" class="form-control" value="<?= ContentHelper::generateGibberish(12, ContentHelper::DEFAULT_GIBBERISH_CHARACTERS . "_"); ?>">
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</section>
						<section class="card mt-3">
							<div class="card-header">
								<h5>Initial Page Creation</h5>
							</div>
							<div class="card-body">
								<p>
									Uplift comes prepackaged with initial pages to be created. You may opt out of them all or cherry-pick which pages you would like to have automatically created.
								</p>
								<div>
									<div class="form-check form-switch">
										<input class="form-check-input" type="checkbox" role="switch" name="enable-initial-page-creation" id="enable-initial-page-creation-input" checked>
										<label class="form-check-label" for="enable-initial-page-creation-input">Enable initial page creation</label>
									</div>
									<div id="initial-page-selection">
										<?php
											foreach($initialPages as $initialPage){
												$htmlID = sprintf("initial-page-%s", basename($initialPage->fullFilePath));
												?>
												<div class="form-check form-switch">
													<input data-filename="<?= basename($initialPage->fullFilePath) ?>" class="form-check-input form-check-input-for-page" type="checkbox" role="switch" id="<?= $htmlID ?>" checked>
													<label class="form-check-label" for="<?= $htmlID ?>"><?= $initialPage->pageName ?></label>
												</div>
												<?php
											}
										?>
									</div>
								</div>
							</div>
						</section>
					</form>
				</div>
				<div class="card-footer">
					<div class="text-end">
						<button type="submit" form="installation-form" class="btn btn-success px-5">
							<i class="bi bi-cloud-arrow-up-fill"></i>
							<span>Install</span>
						</button>
					</div>
				</div>
			</div>
		</div>
	</installation>
}