<?php

	use Accounts\Account;
	use Roles\PermissionCategories;

	$account = Account::getCurrentUser();
?>
@Layout = "backend-basic.php"
@Head{
	<title>Image Gallery Management</title>
	<script defer src="/uplift-assets/js/_external/popper.min.js"></script>
	<script type="module" src="/uplift-assets/js/image-manager/ImageManager.js"></script>
	<script type="module" src="/uplift-assets/js/image-gallery/ImageGallery.js"></script>
}
@Body{
	<input type="hidden" id="has-image-manager-perms" value="<?= $account->hasPermission(PermissionCategories::MANAGE_IMAGES) ? "1" : "0" ?>">
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<div class="d-flex justify-content-between align-items-center">
								<h2 class="h6 mb-0">
									Image Galleries
								</h2>
								<button type="button" class="btn btn-success" id="new-gallery-modal-trigger-button">
									<i class="bi bi-plus-circle-fill"></i>
									<span>New Gallery</span>
								</button>
							</div>
						</div>
						<div class="card-body">
							<div id="gallery-rows-headers" class="gallery-table-columns">
								<div class="icon">
									<strong></strong>
								</div>
								<div class="name">
									<strong>Gallery Name</strong>
								</div>
								<div class="image-member-count">
									<strong># Images</strong>
								</div>
								<div class="creation-time">
									<strong>Creation Date</strong>
								</div>
							</div>
							<div id="gallery-rows-container"></div>
							<div id="gallery-loader">
								<div class="text-center">
									<div class="spinner-border" style="width:4rem; height:4rem;"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>

	<?php include __DIR__ . "/../_partials/image-manager/_main.php" ?>
	<?php include __DIR__ . "/modals/new-gallery-modal.html" ?>
	<?php include __DIR__ . "/modals/rename-gallery-modal.html" ?>
	<?php include __DIR__ . "/modals/manage-gallery-modal.html" ?>
}
