<?php
	/** @var array $viewScope */

	use Accounts\Account;
	use Page\ArticleCategory;
	use Page\PageType;
	use ProjectPostTag\ProjectPostTag;
	use Roles\PermissionCategories;

	/** @var Account $account */
	$account = Account::getCurrentUser();

	/** @var ArticleCategory $articleCategories */
	$articleCategories = $viewScope['articleCategories'];

	/** @var ProjectPostTag $projectPostTags */
	$projectPostTags = $viewScope['projectPostTags'];

	$pageTypes = PageType::cases();
	sort($pageTypes);
?>
@Layout = "backend-page-editor.php"
@Head{
	<title>Easy Editor</title>
	<link rel="stylesheet" href="/uplift/theme-manager/get-fonts/fonts.css">
	<script src="/uplift-assets/js/_external/tinymce/tinymce.min.js"></script>
	<script type="module" src="/uplift-assets/js/editors/easy-editor/EasyEditorManager.js"></script>
}
@Body{
	<cms-editor-container>
		<div id="content-editor-page-container">
			<aside id="content-editor-sidebar">
				<section id="content-editor-page-navigation-column">
					<section id="pages-categories-loader">
						<div class="spinner-border text-primary"></div>
					</section>
					<section id="pages-categories-main" style="display:none;">
						<div class="page-types-title-container" style="min-height:50px;">
							<h4>Page Types</h4>
						</div>
						<div class="category-buttons-container">
							<?php if($account->hasPermission(PermissionCategories::MANAGE_BLOG_PAGES)) { ?>
							<button type="button" data-page-enum="Blog" class="page-type-enum-button">
								<span>
									<span class="icon-container">
										<i class="bi bi-file-break-fill"></i>
									</span>
									<span class="text-container">
										<span class="label">Blog Pages</span>
										<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
									</span>
								</span>
							</button>
							<?php } if($account->hasPermission(PermissionCategories::MANAGE_CITY_PAGES)) { ?>
							<button type="button" data-page-enum="City" class="page-type-enum-button">
								<span>
									<span class="icon-container">
										<i class="bi bi-file-break-fill"></i>
									</span>
									<span class="text-container">
										<span class="label">City Pages</span>
										<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
									</span>
								</span>
							</button>
							<?php } if($account->hasPermission(PermissionCategories::MANAGE_GENERAL_PAGES)) { ?>
							<button type="button" data-page-enum="General" class="page-type-enum-button">
								<span>
									<span class="icon-container">
										<i class="bi bi-file-break-fill"></i>
									</span>
									<span class="text-container">
										<span class="label">General Pages</span>
										<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
									</span>
								</span>
							</button>
							<?php } if($account->hasPermission(PermissionCategories::MANAGE_PROJECT_PAGES)) { ?>
							<button type="button" data-page-enum="Project" class="page-type-enum-button">
								<span>
									<span class="icon-container">
										<i class="bi bi-file-break-fill"></i>
									</span>
									<span class="text-container">
										<span class="label">Project Pages</span>
										<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
									</span>
								</span>
							</button>
							<?php } if($account->hasPermission(PermissionCategories::MANAGE_SERVICE_PAGES)) { ?>
							<button type="button" data-page-enum="Service" class="page-type-enum-button">
								<span>
									<span class="icon-container">
										<i class="bi bi-file-break-fill"></i>
									</span>
									<span class="text-container">
										<span class="label">Service Pages</span>
										<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
									</span>
								</span>
							</button>
							<?php } ?>
						</div>
					</section>
					<page-categories-sidebar style="display:none;">
						<section id="page-type-title-container" style="min-height:50px;">
							<h4>
								<span class="page-type-title"></span>
								<span>Pages</span>
							</h4>
						</section>
						<section id="sidebar-buttons-container">
							<button type="button" id="page-category-back-button" class="w-100">
								<i class="bi bi-arrow-left-circle-fill"></i>
								<span>Back</span>
							</button>
						</section>
						<section id="page-lists-container">
							<?php foreach($pageTypes as $case){ ?>
							<section style="display:none;" class="page-list" data-page-category="<?= $case->name ?>"></section>
							<?php } ?>
						</section>
					</page-categories-sidebar>
				</section>
			</aside>
			<div class="d-flex flex-column w-100 position-relative">
				<div id="content-editor-options-bar" style="min-height:50px;">
					<section class="editor-toolbar-editor-buttons"></section>
					<section style="" id="editor-page-buttons-toolbar" class="editor-toolbar-page-buttons">
						<a id="view-page-external-link-button" href="#" target="_blank" class="btn btn-secondary btn-sm mr-2" style="display:none;">
							<i class="bi bi-box-arrow-up-right"></i>
							<span>View Page</span>
						</a>
						<button class="btn btn-success btn-sm" type="submit" form="page-edit-form" style="display:none;">
							<i class="bi bi-save-fill"></i>
							<span>Save (Ctrl + S)</span>
						</button>
					</section>
				</div>
				<div id="easy-editor-loading-container" style="display:flex;">
					<div class="spinner-grow text-primary" role="status">
						<span class="visually-hidden">Loading...</span>
					</div>
				</div>
				<div id="easy-editor-single-instance-container" style="display: none;">
					<textarea id="content-editor-container" style="opacity:0"></textarea>
				</div>
				<div id="easy-editor-sections-instance-container" style="display: none;"></div>
			</div>
		</div>
	</cms-editor-container>

	<!-- Image manager and modals -->
	<?php
		include __DIR__ . "/../page-editor/modals/blog-reel.php";
		include __DIR__ . "/../page-editor/modals/ipp-reel.php";
		include __DIR__ . "/../page-editor/modals/recent-articles.php";
		include __DIR__ . "/../page-editor/modals/recent-projects.php";
	?>
}