<?php
	/** @var array{searchConsoleEmail: string|null, searchConsoleSite: string|null} $viewScope */

	use Google\GoogleAccount;
	use Google\GoogleAccountSearchConsoleSite;
	use Nox\ORM\ColumnQuery;

	$searchConsoleEmail = $viewScope['searchConsoleEmail'];
	$searchConsoleSite = $viewScope['searchConsoleSite'];
?>
@Layout = "backend-basic.php"
@Head{
	<title>Uplift Dashboard</title>
	<script type="module" defer src="/uplift-assets/js/dashboard/Dashboard.js"></script>
}
@Body{
	<div id="dashboard-container">
		<?php
			if ($searchConsoleEmail === null){
				?>
				<div class="alert alert-primary">
					<h3>No Search Console Linked</h3>
					<p>
						This is the main dashboard of the Uplift CMS. The home dashboard allows you to view the Google Search Console data about your website.
					</p>
					<p>
						There is currently no Google Search Console linked. Please click the button below and sign in with a Google account that has access to the Google Search Console for this website.
					</p>
					<button id="link-google-account-button" type="button" class="btn btn-primary btn-sm">
						<i class="bi bi-google"></i>
						<span>Link Google Search Console Account</span>
					</button>
				</div>
				<?php
			}else{
				?>
				<div>
					<div id="graph-date-range-container">
						<h1>Dashboard - Search Performance Insights</h1>
						<div class="mb-3">
							<div class="container-fluid p-0">
								<div class="row align-items-center">
									<div class="col-xl-2">
										<strong>Website selected</strong>
									</div>
									<div class="col-xl-4">
										<select id="search-console-site-select-menu" class="form-control" name="search-console-site">
											<?php
												/** @var GoogleAccount $googleAccount */
												$googleAccount = GoogleAccount::queryOne(
													columnQuery: (new ColumnQuery())
														->where("email","=",$searchConsoleEmail)
												);
												/** @var GoogleAccountSearchConsoleSite[] $availableSites */
												$availableSites = GoogleAccountSearchConsoleSite::query(
													columnQuery: (new ColumnQuery())
														->where("google_account_row_id","=",$googleAccount->id)
												);

												foreach($availableSites as $availableSite){
													?>
													<option <?= $availableSite->site === $searchConsoleSite ? "selected" : "" ?> value="<?= $availableSite->id ?>"><?= $availableSite->site ?></option>
													<?php
												}
											?>
										</select>
									</div>
									<div class="col-xl">
										<button id="set-as-website-button" style="display:none;" type="button" class="btn btn-success btn-sm">
											<i class="bi bi-check-circle-fill"></i>
											<span>Set Website</span>
										</button>
									</div>
								</div>
							</div>
						</div>
						<hr>
						<div class="d-flex justify-content-between align-items-center">
							<div id="filters-buttons-container" class="d-inline-flex align-items-center">
								<button type="button" id="add-filter-button" class="btn btn-text text-dark">
									<i class="bi bi-plus"></i>
									<span>Add filter</span>
								</button>
							</div>
							<div class="d-inline-flex align-items-center">
								<button type="button" class="btn btn-primary btn-sm">
									<i class="bi bi-calendar-date-fill"></i>
									<span>Set Date Range</span>
								</button>
								<div id="current-date-range-container">
									<span>Last 3 Months</span>
								</div>
							</div>
						</div>
					</div>
					<div id="main-graph-container">
						<div class="card">
							<div class="card-header">
								<h2 class="mb-0">Search Metrics</h2>
							</div>
							<div class="card-body">
								<canvas id="main-graph"></canvas>
							</div>
						</div>
					</div>
					<div id="search-data-container">
						<div class="card">
							<div class="card-header">
								<div id="search-data-tabs-container">
									<button type="button" class="selected">
										<i class="bi bi-search"></i>
										<span>Queries</span>
									</button>
									<button type="button">
										<i class="bi bi-file-earmark-break-fill"></i>
										<span>Pages</span>
									</button>
									<button type="button">
										<i class="bi bi-pin-map-fill"></i>
										<span>Countries</span>
									</button>
								</div>
							</div>
							<div class="card-body">
								<table class="table" id="search-data-table">
									<thead>
										<tr>
											<td id="sd-th-queries">Queries</td>
											<td id="sd-th-pages" style="display:none;">Pages</td>
											<td id="sd-th-countries" style="display:none;">Countries</td>
										</tr>
									</thead>
								</table>
							</div>
						</div>
					</div>
				</div>
				<?php
			}
		?>
	</div>
}
