<?php
	// To test this form with test inputs,
	// add ?test to the URL

	use Nox\ORM\ColumnQuery;
	use Nox\ORM\ResultOrder;
	use Page\Page;
	use Page\PageType;
	use Settings\Setting;
	use Settings\Settings;

	$acceloCompanyID = Setting::getSettingValue(Settings::ACCELO_COMPANY_ID->value);
	$maximumImageUploadSizeInBytes = \System\System::getMaximumUploadSizeInBytes();
	$maxUploadSizeStringInMB = sprintf("%dMB", round($maximumImageUploadSizeInBytes / (1024 * 1024)));

	/** @var Page[] $servicePages */
	$servicePages = Page::query(
		columnQuery: (new ColumnQuery())
			->where("pageType", "=", PageType::Service->name)
	);

	/** @var Page[] $cityPages */
	$cityPages = Page::query(
		columnQuery: (new ColumnQuery())
			->where("pageType", "=", PageType::City->name),
			resultOrder: (new ResultOrder())
				->by("pageName", "ASC")
	);
?>
@Layout = "backend-project-form.php"
@Head{
	<title>Submit a Project</title>
	<script type="module" src="/uplift-assets/js-prod/client-project-form/ClientProjectForm.js?5"></script>
	<script type="module" src="/uplift-assets/js-out/ClientProjectForm/ClientProjectForm.js?5"></script>
	<script src="/uplift-assets/js-prod/client-project-form/JsCompatibilityMessageLoader.js"></script>
}
@Body{
	<?php include __DIR__ . "/_partials/top-bar.html" ?>
	<input type="hidden" id="missing-accelo-company-id-input" value="<?= empty($acceloCompanyID) ? 1 : 0 ?>">
	<div id="client-project-form-could-not-load" class="p-5" style="display:none;">
		<div class="alert alert-danger text-center">
			<span>The project form could not be loaded. Most likely you are using an outdated browser on a device that may also be outdated. If this issue persists, please try using a different device.</span>
		</div>
	</div>
	<div id="client-project-form-loader">
		<div class="my-5 text-center">
			<div class="spinner spinner-grow mb-3 text-primary" style="width:7.5rem; height:7.5rem;"></div>
			<div>
				<h4>Loading project form...</h4>
			</div>
		</div>
	</div>
	<div id="client-project-form-page-container" style="display:none;">
		<?php
			if (empty($acceloCompanyID)){
				?>
				<div class="alert alert-warning">
					<h4>Missing Accelo Setting</h4>
					<p>
						This system is missing the Accelo company ID setting. Please set this setting in the Uplift settings panel to the ID of the company in the Accelo CRM. If you are a client, then please reach out to your webmaster to do this for you.
					</p>
				</div>
				<?php
			}else{
				?>
					<div id="submitting-error-container" style="display:none;">
						<div class="alert alert-danger">
							<h5>There was an error</h5>
							<div id="submitting-error-message-container" class="my-3"></div>
							<button type="button" id="fix-it-error-button" class="btn btn-sm btn-danger">
								<i class="bi bi-skip-backward-circle-fill"></i>
								<span>Back to the form</span>
							</button>
						</div>
					</div>
					<?php include_once __DIR__ . "/_partials/success.html" ?>
					<div id="submitting-loader-container" style="display:none;">
						<div>
							<div class="alert alert-info">
								<h6>We are now uploading your project and then its images - <strong>do not</strong> leave this page until it has finished.</h6>
							</div>
						</div>
						<hr>
						<div id="textual-section-submitting-container">
							<div id="textual-loader-alert-container" class="alert alert-primary">
								<div>
									<h5 id="textual-submission-headline">.</h5>
								</div>
								<div id="textual-section-spinner-container">
									<div class="spinner-grow text-primary" style="width:5rem; height:5rem;"></div>
								</div>
							</div>
						</div>
						<div id="media-section-submitting-container">
							<div id="media-loader-alert-container" class="alert alert-warning">
								<div>
									<h5 id="media-submission-headline"></h5>
								</div>
								<div id="media-section-spinner-container" style="display:none;">
									<div class="spinner-grow text-primary" style="width:5rem; height:5rem;"></div>
								</div>
							</div>
						</div>
					</div>
					<div id="form-card" class="card shadow">
						<div class="card-header">
							<h1 class="h3 mb-0">Submit a Project Post for your Website</h1>
						</div>
						<div class="card-body">
							<form id="client-project-form-textual-section">
								<?php
									if (\NoxEnv::DEV_ENV === "development"){
										?>
										<div class="alert alert-info mb-3">
											Because you are in a development environment, you can append ?test to your URL to auto-fill data in for testing.
										</div>
										<?php
									}
								?>
								<div class="mb-3">
									<span class="required-symbol">*</span> = Required form field
								</div>
								<hr>
								<div>
									<label for="project-title-input"><span class="required-symbol">*</span> Title of your project</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-fonts"></i></div>
										<input type="text" autocomplete="offf" class="form-control" name="project-title" id="project-title-input">
									</div>
									<small><strong>Avoid titles like</strong> "Another X Project" and instead opt for a title more presentable and with SEO value. Consider a title such as "Top Quality (Service Name Here) Performed in (Town), (State)"</small>
								</div>
								<div class="mt-5">
									<div class="container-fluid p-0">
										<div class="row g-0">
											<div class="col-xl-8 pe-0 pe-xl-5">
												<label for="project-description-input"><span class="required-symbol">*</span> Describe the project in detail</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-body-text"></i></div>
													<textarea class="form-control" autocomplete="offf" name="project-description" id="project-description-input"></textarea>
												</div>
												<div id="content-optimization-labels">
													<div class="container-fluid p-0 mt-1">
														<div class="row justify-content-between">
															<div class="col" id="word-count-label-column">
																<span style="display:none;" class="met text-success"><i class="bi bi-check-circle-fill"></i></span>
																<span class="not-met">-</span>
																<span>Good word count</span>
															</div>
															<div class="col text-center" id="primary-service-label-column">
																<span style="display:none;" class="met text-success"><i class="bi bi-check-circle-fill"></i></span>
																<span class="not-met">-</span>
																<span>Primary service mentioned</span>
															</div>
															<div class="col text-end" id="city-label-column">
																<span style="display:none;" class="met text-success"><i class="bi bi-check-circle-fill"></i></span>
																<span class="not-met">-</span>
																<span>City location mentioned</span>
															</div>
														</div>
													</div>
												</div>
												<div id="content-length-info-container" class="my-2">
													<strong>Content Optimization</strong>: <span id="content-length-text">Poor</span>
													<div id="content-length-outer-optimization-bar">
														<div id="content-length-inner-optimization-bar"></div>
													</div>
													<div>
														<small>Improve content optimization by extending the length of your content, having keywords of your main service performed and the location the project performed.</small>
													</div>
												</div>
											</div>
											<div class="col-xl">
												<h5>Why is this important?</h5>
												<p>
													Being descriptive about the work you performed adds to the legitimacy of the project post and the value the content provides for SEO purposes. It's important to mention the service provided, the general location, and some information about the "why" the service was performed. What did it accomplish? Is it preventative? The more information and keyword-centric content you add to your project post, then the more beneficial it is to the overall SEO effort of the website.
												</p>
											</div>
										</div>
										<div class="row g-0">
											<div class="col-xl-8">
												<div id="no-service-keyword-warning" style="display:none;" class="alert alert-warning my-2">
													<span><i class="bi bi-exclamation-triangle-fill"></i></span> <span>Your project description should mention the primary service you performed at least once. The primary service you have selected is <strong id="primary-service-text"></strong>.</span>
												</div>
												<div id="no-city-keyword-warning" style="display:none;" class="alert alert-warning my-2">
													<span><i class="bi bi-exclamation-triangle-fill"></i></span> <span>Your project description should mention the city and state you performed in at least once.
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="mt-3">
									<div class="container-fluid p-0">
										<div class="row">
											<div class="col">
												<div class="card">
													<div class="card-header">
														<h2 class="fs-3 mb-0">Service Optimization</h2>
													</div>
													<div class="card-body">
														<p>
															Projects should be optimized for a specific service and a location. Your website has dedicated <em>service pages</em> for optimization of a specific service. Please select the correct service page this project <strong>primarily</strong> represents.
														</p>
														<div class="input-group">
															<label for="service-page-id-input" class="input-group-text">
																<i class="bi bi-hammer"></i>
															</label>
															<select id="service-page-id-input" class="form-control" name="service-page-id">
																<option value="0">- Select a Service -</option>
																<?php
																	foreach($servicePages as $servicePage){
																		?>
																		<option value="<?= $servicePage->id ?>"><?= htmlspecialchars($servicePage->pageName) ?></option>
																		<?php
																	}
																?>
																<option value="-1">- Other / Not Listed -</option>
															</select>
														</div>
														<div>
															<small>If you don't see the service page for the service you performed, consider requesting our Support staff (support@footbridgemedia.com) add a service page for that service <em>before</em> you upload this project.</small>
														</div>
														<hr>
														<h6 class="mb-0">Advanced: Categorize Your Project With a Tag</h6>
														<div class="mb-2">
															<small>This section is not required, but can be used internally for categorizing your project. Depending on how your website was built, tagging your project may help it show on other pages. These tags are defined by the website support department. Click on the tags to select them.</small>
														</div>
														<div>
															<strong>Tags: </strong>
															<div class="d-inline-block" id="tags-buttons-list"></div>
															<div class="d-inline-block" id="tags-loader">
																<div class="spinner-border" style="width:1rem; height: 1rem;"></div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<hr>
								<div class="mt-3">
									<div class="container-fluid p-0">
										<div class="row g-0">
											<div class="col">
												<h2>Location Optimization</h2>
												<div class="input-group">
													<label for="city-page-id-input" class="input-group-text">
														<i class="bi bi-hammer"></i>
													</label>
													<select id="city-page-id-input" class="form-control" name="city-page-id">
														<option value="0">- Select a City Location -</option>
														<?php
															foreach($cityPages as $cityPage){
																?>
																<option value="<?= $cityPage->id ?>"><?= htmlspecialchars($cityPage->pageName) ?></option>
																<?php
															}
														?>
														<option value="-1">- Other / Not Listed -</option>
													</select>
												</div>
											</div>
										</div>
										<div id="custom-project-location-fields" style="display:none;" class="row g-0 mt-3">
											<div class="col-12">
												<p>
													Fill in the project's location using the fields below since you have selected there isn't an existing city page for that project.
												</p>
											</div>
											<div class="col-xl-5 pe-xl-2 pe-0">
												<label for="project-location-city-input"><span class="required-symbol">*</span> Project city location</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-building"></i></div>
													<input type="text" class="form-control" autocomplete="offf" name="project-location-city" id="project-location-city-input">
												</div>
												<small>E.g., Dallas</small>
											</div>
											<div class="col-xl-3 ps-xl-2 ps-0">
												<label for="project-location-state-input"><span class="required-symbol">*</span> Project state or province <strong>abbr.</strong></label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-building"></i></div>
													<input type="text" class="form-control" autocomplete="offf" name="project-location-state" id="project-location-state-input">
												</div>
												<small>Use shorthand, such as TX or AD and <strong>not</strong> Texas or Adelaide</small>
											</div>
											<div class="col-xl ps-xl-2 ps-0">
												<label for="project-location-state-full-input"><span class="required-symbol">*</span> Project <strong>full</strong> state or province</label>
												<div class="input-group">
													<div class="input-group-text"><i class="bi bi-building"></i></div>
													<input type="text" class="form-control" autocomplete="offf" name="project-location-state-full" id="project-location-state-full-input">
												</div>
												<small>Full name state name</small>
											</div>
										</div>
									</div>
								</div>
								<div class="mt-3">
									<label for="project-budget-input">Project budget</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-currency-dollar"></i></div>
										<input type="text" class="form-control" autocomplete="offf" name="project-budget" id="project-budget-input">
									</div>
									<div>
										<small><strong>Note</strong>: <span>If you do not want the budget shown on the website, leave the budget field blank.</span></small>
									</div>
								</div>
								<div class="mt-3">
									<label for="project-materials-input">Brands or materials used</label>
									<div class="input-group">
										<div class="input-group-text"><i class="bi bi-hammer"></i></div>
										<input type="text" class="form-control" autocomplete="offf" name="project-materials" id="project-materials-input">
									</div>
								</div>
								<div class="mt-3">
									<div>
										<span>Did your customer leave a review about this project?</span>
									</div>
									<div class="form-check">
										<input checked class="form-check-input" type="radio" id="customer-review-check-no" name="customer-review-check" value="0">
										<label class="form-check-label" for="customer-review-check-no">
											No - my customer did not leave a review.
										</label>
									</div>
									<div class="form-check">
										<input class="form-check-input" type="radio" id="customer-review-check-yes" name="customer-review-check" value="1">
										<label class="form-check-label" for="customer-review-check-yes">
											Yes - they left a review, and I will fill out the information below.
										</label>
									</div>
								</div>
								<div id="customer-review-container" style="display:none;" class="mt-3">
									<div>
										<div class="container-fluid p-0">
											<div class="row g-0">
												<div class="col-xl pe-xl-2 ps-0">
													<label for="customer-first-name-input">Customer first name</label>
													<div class="input-group">
														<div class="input-group-text"><i class="bi bi-file-person-fill"></i></div>
														<input type="text" autocomplete="offf" class="form-control" name="customer-first-name" id="customer-first-name-input">
													</div>
												</div>
												<div class="col-xl ps-xl-2 ps-2">
													<label for="customer-last-name-input">Customer last initial</label>
													<div class="input-group">
														<div class="input-group-text"><i class="bi bi-file-person-fill"></i></div>
														<input type="text" autocomplete="offf" class="form-control" name="customer-last-name" id="customer-last-name-input">
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="mt-3">
										<label for="project-customer-testimonial-input">Provide the customer's review</label>
										<div class="input-group">
											<div class="input-group-text"><i class="bi bi-bookmark-star-fill"></i></div>
											<textarea class="form-control" name="project-customer-testimonial" id="project-customer-testimonial-input"></textarea>
										</div>
									</div>
								</div>
							</form>
							<form id="client-project-form-media-section">
								<div id="images-section-container">
									<div class="mt-3">
										<h3 class="mb-3">Upload Project Images</h3>
										<div class="alert alert-warning">
											<span>The maximum size of any singular image you can upload is <strong id="max-file-upload-size" data-in-bytes="<?= $maximumImageUploadSizeInBytes ?>"><?= $maxUploadSizeStringInMB ?></strong></span>
										</div>
										<div class="card">
											<div class="card-header">
												<h5><span class="required-symbol">*</span> Cover Photo</h5>
											</div>
											<div class="card-body">
												<p>
													This is the main photo you want displayed on your project. It will be the main photo in the content of the page and used on thumbnails when the project is shown on other pages.
												</p>
												<div class="client-project-form-fake-upload-container">
													<input accept=".jpeg,.jpg,.png,.gif,.webp,.heic" type="file" name="cover-photo" id="cover-photo-input">
													<label for="cover-photo-input"></label>
												</div>
											</div>
										</div>
										<div class="card mt-3">
											<div class="card-header">
												<h5>Additional Images</h5>
											</div>
											<div class="card-body">
												<p>
													Click "Add Another Image" and then use the upload button that appears to add another image to your form.
												</p>
												<p>
													<strong>Note</strong> - You can click and drag the handle icons to re-order your images before uploading this project.
												</p>
												<p>
													<button type="button" id="add-another-image-button" class="btn btn-primary">
														<i class="bi bi-plus-square-fill"></i>
														<span>Add Another Image</span>
													</button>
												</p>
												<div id="additional-image-components-container"></div>
											</div>
										</div>
									</div>
								</div>
								<div class="mt-3">
									<hr>
									<button id="form-submit-button" form="client-project-form-textual-section" type="submit" class="btn btn-primary px-5">
										<i class="bi bi-send-plus-fill"></i>
										<span>Submit Project</span>
									</button>
								</div>
							</form>
						</div>
					</div>
				<?php
			}
		?>
	</div>
}