<?php
	/** @var array $viewScope */

	$activityLogCategories = $viewScope['activityLogCategories'];
?>
@Layout = "backend-basic.php"
@Head{
	<title>Activity Logs</title>
	<script type="module" defer src="/uplift-assets/js/_external/bootstrap/collapse.js"></script>
	<script type="module" src="/uplift-assets/js-out/ActivityLogs/ActivityLogs.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<div class="d-flex justify-content-between align-items-center">
								<h2 class="h6 my-2">
									Activity Logs
								</h2>
							</div>
						</div>
						<div class="card-body">
							<div class="d-flex justify-content-end mb-3">
								<form>
									<select class="form-select" id="category-select">
										<option value="0" selected>All Logs</option>
										<?php
											$arrayColumn = array_column($activityLogCategories, "name");
											array_multisort($arrayColumn, $activityLogCategories);

											foreach($activityLogCategories as $category) {
												echo("<option value='$category->value'>" . $category->name. "</option>");
											}
										?>
									</select>
								</form>
							</div>
							<div id="activity-log-loader" class="text-center" style="display: none;">
								<div style="width:5rem; height:5rem;" class="spinner-border" role="status">
									<span class="visually-hidden">Loading...</span>
								</div>
							</div>
							<div id="activity-log-rows-container" data-user=""></div>
							<p id="no-logs-to-display-message" style="display: none;">
								There are no logs of this category type.
							</p>
							<div class="d-flex justify-content-end">
								<?php include __DIR__ . "/../_partials/pagination.html" ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>
}
