<?php
	use Accounts\Account;
	use Page\Page;
	use Roles\PermissionCategories;

	$account = Account::getCurrentUser();
	$page = Page::getCurrentPage();
?>
<meta name="viewport" content="width=device-width, initial-scale=1">

<?= \Uplift\Vite\ViteStaticService::Use([
    new \App\Vite\ViteResource("/uplift-core/resources/static/css/public-front-end/main.scss", "PublicFrontEnd")
]) ?>

<public-front-end-admin-bar style="display:none;">
	<div id="ucms-bar-container">
		<div class="ucms-column-1">
			<div class="ucms-logo-container">
				<a href="/uplift/dashboard">
					<img alt="Uplift logo" src="/uplift-assets/images/uplift-logo-favicon.png" height="42">
				</a>
			</div>
			<div class="ucms-links-container">
				<div>
					<a href="/uplift/dashboard">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-speedometer" viewBox="0 0 16 16">
							<path d="M8 2a.5.5 0 0 1 .5.5V4a.5.5 0 0 1-1 0V2.5A.5.5 0 0 1 8 2zM3.732 3.732a.5.5 0 0 1 .707 0l.915.914a.5.5 0 1 1-.708.708l-.914-.915a.5.5 0 0 1 0-.707zM2 8a.5.5 0 0 1 .5-.5h1.586a.5.5 0 0 1 0 1H2.5A.5.5 0 0 1 2 8zm9.5 0a.5.5 0 0 1 .5-.5h1.5a.5.5 0 0 1 0 1H12a.5.5 0 0 1-.5-.5zm.754-4.246a.389.389 0 0 0-.527-.02L7.547 7.31A.91.91 0 1 0 8.85 8.569l3.434-4.297a.389.389 0 0 0-.029-.518z"/>
							<path fill-rule="evenodd" d="M6.664 15.889A8 8 0 1 1 9.336.11a8 8 0 0 1-2.672 15.78zm-4.665-4.283A11.945 11.945 0 0 1 8 10c2.186 0 4.236.585 6.001 1.606a7 7 0 1 0-12.002 0z"/>
						</svg>
						<span>Dashboard</span>
					</a>
				</div>
				<?php
					if (
						$account->hasPermission(PermissionCategories::EDIT_PAGES)
						&&
						$account->hasPermission(PermissionCategories::ACCESS_PAGE_EDITOR)
					){
				?>
				<div>
					<a href="/uplift/page-editor/<?= $page->id ?>">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-fill" viewBox="0 0 16 16">
							<path d="M12.854.146a.5.5 0 0 0-.707 0L10.5 1.793 14.207 5.5l1.647-1.646a.5.5 0 0 0 0-.708l-3-3zm.646 6.061L9.793 2.5 3.293 9H3.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.207l6.5-6.5zm-7.468 7.468A.5.5 0 0 1 6 13.5V13h-.5a.5.5 0 0 1-.5-.5V12h-.5a.5.5 0 0 1-.5-.5V11h-.5a.5.5 0 0 1-.5-.5V10h-.5a.499.499 0 0 1-.175-.032l-.179.178a.5.5 0 0 0-.11.168l-2 5a.5.5 0 0 0 .65.65l5-2a.5.5 0 0 0 .168-.11l.178-.178z"/>
						</svg>
						<span>Edit Page</span>
					</a>
				</div>
				<?php
					}
				?>
			</div>
		</div>
		<div class="ucms-column-2">
			<div class="ucms-user-section">
				<strong>Logged in as:</strong><span><?= $account->getFullName() ?></span>
			</div>
			<div class="ucms-collapse-button-container">
				<button type="button" id="ucms-hide-bar">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-bar-left" viewBox="0 0 16 16">
						<path fill-rule="evenodd" d="M12.5 15a.5.5 0 0 1-.5-.5v-13a.5.5 0 0 1 1 0v13a.5.5 0 0 1-.5.5zM10 8a.5.5 0 0 1-.5.5H3.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L3.707 7.5H9.5a.5.5 0 0 1 .5.5z"/>
					</svg>
					<span>Hide</span>
				</button>
			</div>
		</div>
	</div>
</public-front-end-admin-bar>
<button type="button" id="public-front-end-admin-bar-toggle" style="display:none;">
	<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-bar-right" viewBox="0 0 16 16">
		<path fill-rule="evenodd" d="M6 8a.5.5 0 0 0 .5.5h5.793l-2.147 2.146a.5.5 0 0 0 .708.708l3-3a.5.5 0 0 0 0-.708l-3-3a.5.5 0 0 0-.708.708L12.293 7.5H6.5A.5.5 0 0 0 6 8zm-2.5 7a.5.5 0 0 1-.5-.5v-13a.5.5 0 0 1 1 0v13a.5.5 0 0 1-.5.5z"/>
	</svg>
</button>