<image-manager-container id="image-manager-container" tabindex="-1" style="display:none;">
	<image-manager-window>
		<im-window-title>
			<div class="d-flex">
				<div class="im-heading-container">
					<h5>Image Manager</h5>
				</div>
				<div class="im-close-button-container">
					<button type="button" class="im-modal-dismiss-button"><i class="bi bi-x-octagon-fill"></i></button>
				</div>
			</div>
		</im-window-title>
		<im-location-bar>
			<div class="location-pin" title="Current folder location">
				<i class="bi bi-geo-alt-fill"></i>
			</div>
			<div class="location-buttons">
				<im-location-button>
					<span class="folder-name">Images</span>
				</im-location-button>
				<im-location-button>
					<span class="folder-name">Projects</span>
				</im-location-button>
			</div>
			<div id="im-location-input-field-container" style="display:none;">
				<form id="im-location-form">
					<input autocomplete="off" type="text" class="form-control" id="im-location-input-field">
				</form>
			</div>
			<div class="im-current-location-search">
				<form id="im-filter-current-location-form">
					<input autocomplete="off" class="form-control" type="text" placeholder="Filter current images" name="filter-query">
				</form>
			</div>
		</im-location-bar>
		<im-window-body>
			<nav class="folder-column">
				<div class="folder-headers-row">
					<button type="button" class="refresh-directories-button">
						<i class="bi bi-arrow-clockwise"></i>
					</button>
				</div>
				<div class="folders-container"></div>
			</nav>
			<div class="folder-contents-container">
				<div class="im-images-loading-container" style="display:none;">
					<div class="text-center">
						<div class="spinner-border" style="width:5rem; height:5rem;"></div>
					</div>
					<div class="text-center">
						<span>Loading images...</span>
					</div>
				</div>
				<div class="im-no-images-message" style="display:none;">
					<div class="text-center">
						<em>No images in this directory.</em>
					</div>
				</div>
				<div id="im-upload-container" style="display:none;">
					<div class="im-upload-icon-container">
						<i class="bi bi-cloud-upload-fill"></i>
					</div>
					<div id="im-uploading-spinner" style="display:none;">
						<div class="spinner-border text-light" role="status"></div>
					</div>
					<div id="im-upload-before-drop">
						<span>Drop images here to upload them to this folder.</span>
					</div>
					<div id="im-upload-after-drop" style="display:none;">
						<span>Uploaded <span id="im-finished-upload-number">0</span> of <span id="im-in-queue-upload-number">1</span></span>
					</div>
				</div>
				<div class="im-images-header-row">
					<div class="im-header-image-name">
						<span>Image name</span>
					</div>
					<div class="im-header-image-type">
						<span>Image type</span>
					</div>
					<div class="im-header-file-size">
						<span>File size</span>
					</div>
				</div>
				<div class="im-images">
					<im-image>
						<div class="image-name-contents">
							<i class="bi bi-image-fill" image-type="png"></i>
							<span class="image-full-file-name">
								<span class="image-file-name">guy-on-a-duck</span>.<span class="image-file-extension">png</span>
							</span>
						</div>
						<div class="image-type-container">
							<span class="image-type">PNG</span>
						</div>
						<div class="file-size-container">
							<span class="image-file-size">0Kb</span>
						</div>
					</im-image>
				</div>
			</div>
			<div class="img-meta-column">
				<div class="preview-container">
					<div class="image-preview-loader text-center" style="display:none;">
						<div class="spinner spinner-border text-primary" style="width:2.5rem; height:2.5rem;"></div>
					</div>
					<img style="display:none;" class="im-manager-preview" alt="Image preview">
				</div>
				<div class="img-info-container" style="display:none;">
					<div>
						<strong>File size: </strong><span id="im-file-size">0Kb</span>
					</div>
					<div>
						<strong>File type: </strong><span id="im-file-type">?</span>
					</div>
					<div>
						<strong>Dimensions: </strong><span id="im-dimensions">0x0</span>
					</div>
				</div>
			</div>
		</im-window-body>
		<im-window-footer>
			<div class="im-footer-buttons-container flex-grow-1 d-flex">
				<div class="h-100" id="im-os-upload-container">
					<label id="im-manager-os-file-upload-label" for="im-manager-os-file-upload" class="btn btn-primary btn-sm">
						<i class="bi bi-cloud-arrow-up-fill"></i>
						<span>Upload Images</span>
					</label>
					<form id="im-manager-os-file-upload-form">
						<input accept=".gif,.png,.jpg,.jpeg,.webp" type="file" multiple name="im-manager-os-file-upload" id="im-manager-os-file-upload">
					</form>
				</div>
				<div class="h-100 flex-grow-1">
					<div style="display:none;" class="h-100 im-footer-buttons">
						<div style="display:none;" class="im-insertion-mode-buttons h-100 justify-content-end align-items-center px-3">
							<button style="display:none;" tabindex="1" type="button" class="im-quick-gallery-button me-1 btn btn-sm btn-primary px-4">
								<i class="bi bi-images"></i>
								<span>Make Quick Gallery</span>
							</button>
							<button id="im-insert-images-button" tabindex="2" type="button" class="btn btn-sm btn-primary px-4">
								<i class="bi bi-box-arrow-right"></i>
								<span>Insert</span>
							</button>
						</div>
						<div style="display:none;" class="im-selection-mode-buttons h-100 justify-content-end align-items-center px-3">
							<button id="im-select-image-button" tabindex="1" type="button" class="btn btn-sm btn-primary px-4">
								<i class="bi bi-box-arrow-right"></i>
								<span>Select</span>
							</button>
						</div>
					</div>
				</div>
			</div>
			<div id="im-selection-footer">
				<div class="im-selected-image-footer" style="display:none;">
					<strong>URI: </strong><span class="im-selected-image-uri"></span>
				</div>
				<div class="im-selected-images-footer" style="display:none;">
					<strong>Grouped: </strong><span class="im-selected-images-amount">0</span>
				</div>
			</div>
		</im-window-footer>
	</image-manager-window>
	<?php include __DIR__ ."/_resize-window.html"; ?>
	<?php include __DIR__ ."/_crop-window.html"; ?>
	<?php include __DIR__ ."/_clone-window.html"; ?>
	<?php include __DIR__ ."/_quick-gallery-window.html"; ?>
</image-manager-container>