<?php
	/** @var Account $thisAccount */
	use Accounts\Account;
	use Settings\Setting;
	use Settings\Settings;

	$thisAccount = Account::getCurrentUser();
	$companyName = (string) Setting::getSettingValue(Settings::COMPANY_NAME->value);
?>
<backend-admin-topbar>
	<div class="admin-top-bar-nav-buttons-container">
		<div class="nav-button-container">
			<a href="/">
				<i class="bi bi-eye-fill"></i>
				<span>View Site</span>
			</a>
		</div>
		<?php
			if (!empty($companyName)){
				?>
				<div class="nav-button-container company-name-nav-item">
					<div><strong>Company: </strong><span><?= $companyName ?></span></div>
				</div>
				<?php
			}
		?>
	</div>
	<div id="user-topbar-section">
		<div id="user-top-bar-button-container">
			<button type="button" class="user-button">
				<i class="bi bi-person-circle"></i>
				<span><?= $thisAccount->getFullName() ?></span>
				<i class="bi bi-chevron-down"></i>
			</button>
			<div class="user-dropdown">
				<div class="user-dropdown-button-container">
					<a href="/uplift/logout">
						<i class="bi bi-door-open-fill"></i>
						<span>Logout</span>
					</a>
				</div>
			</div>
		</div>
	</div>
</backend-admin-topbar>