import { EditRoleForm } from "./Forms/EditRoleForm";

export class ManageRole{
	private EditRoleFormInstance: EditRoleForm;

    public constructor(){
		this.EditRoleFormInstance = new EditRoleForm();
        window.addEventListener("keydown", e => {
			if (e.ctrlKey){
				if (e.key === "s"){
					e.preventDefault();
					this.OnSaveShortcut();
				}
			}
		});

		document.querySelector("#delete-role-button").addEventListener("click", e => {
			this.OnDelete();
		});
    }

    /**
     * When the user performs crtl+s or cmd+s
	 * @returns {void}
     */
    public OnSaveShortcut(): void{
        // Manually fire the forms submit
		this.EditRoleFormInstance.OnSubmit()
    }

    /**
	 * When the delete button is clicked
	 * @returns {Promise<void>}
	 */
	public async OnDelete(): Promise<void>{
		await this.EditRoleFormInstance.OnDelete();
	}
}

new ManageRole();