import { EndpointsProvider } from "../../../EndpointsProvider";
import { Roles } from "../Roles";

export class NewRoleForm{
    private Form: HTMLFormElement | null = document.querySelector("#new-role-form");
    private IsProcessing: boolean = false;
	private RolesInstance: Roles;

    public constructor(rolesInstance: Roles){
		this.RolesInstance = rolesInstance;
		this.Form = document.querySelector("#new-role-form");
		
        this.Form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		});
    }
    /**
     * Handles a creation of a new role
     * @returns {Promise<void>}
     */
    private async OnSubmit(): Promise<void>{
		if (this.IsProcessing){
			return;
		}

		this.IsProcessing = true;

		const response = await fetch(`${EndpointsProvider.EndPoints.Roles.NewRole}`, {
			body:new FormData(this.Form),
			method:"PUT",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data: {status: number, error?: string};
		try{
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			return;
		}

		if (data.status === 1){
			this.Form.reset();
			this.RolesInstance.NewRoleModal.HideModal();
			await this.RolesInstance.LoadRoles();
		}else if (data.status === -1){
			alert(data.error);
		}

		this.IsProcessing = false;
	}
}