export class Role{
    public static RolesContainer = document.querySelector<HTMLElement>("#roles-rows-container");
    public Id: number;
    public Name: string;
    public CanBeDeleted: boolean;
    public Timestamp: number;
    public Dom: HTMLElement;

    public constructor(
        Id: number,
        Name: string,
        CanBeDeleted: boolean,
        Timestamp: number,
    ){
        this.Id = Id;
		this.Name = Name;
		this.CanBeDeleted = CanBeDeleted;
		this.Timestamp = Timestamp;
		this.Dom = this.GetDOM();

        Role.RolesContainer.append(this.Dom);
    }

	/**
	 * Creates/returns the DOM element representing the role
	 * @returns {HTMLElement}
	 */
    private GetDOM(): HTMLElement{
        const template = document.createElement("role-row");
		const dateString = (new Date(this.Timestamp * 1000)).toLocaleDateString();

		template.classList.add("roles-columns");

		template.innerHTML = `
			<div class="name">
				<span>${this.Name}</span>
			</div>
			<div class="date-created">
				<span>${dateString}</span>
			</div>
			<div class="management-button">
				<a href="/uplift/manage-roles/${this.Id}" class="btn btn-sm btn-primary">
					<i class="bi bi-wrench"></i>
					<span>Manage</span>
				</a>
			</div>
		`;

		return template;
    }
}