import { BaseModal } from "../../Bases/BaseModal";
import { Scheduler } from "../../Utils/Scheduler";
import { ManageReviews } from "../ManageReviews";

export class NewReviewModal extends BaseModal{

    private LastRatingClickedOn = 5;
    private ManageReviewsInstance: ManageReviews;

    public constructor(manageReviewsInstance: ManageReviews){
        super();
        this.ManageReviewsInstance = manageReviewsInstance;
    }

    public override Build(): this{
        const template = document.createElement("div");
        template.classList.add("modal");
        template.setAttribute("id", "new-review-modal");
        template.innerHTML = `
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2 class="modal-title h4 mb-0">Add a New Review</h2>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="new-review-form">
                            <p>
                                Add a first-party review to your website where reviews are shown. We recommend that the format that you use to write in the state field (shorthand or the full spelling) is consistent with existing reviews on your website as certain shortcodes use that state to pull reviews to city pages and other relevant locations.
                            </p>
                            <hr>
                            <div>
                                <div class="container-fluid">
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <label for="new-review-first-name">First name</label>
                                            <input type="text" class="form-control" name="first-name" id="new-review-first-name">
                                        </div>
                                        <div class="col-xl-6">
                                            <label for="new-review-last-name">Last name</label>
                                            <input type="text" class="form-control" name="last-name" id="new-review-last-name">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <label for="new-review-city">City</label>
                                            <input type="text" class="form-control" name="city" id="new-review-city">
                                        </div>
                                        <div class="col-xl-6">
                                            <label for="new-review-state">State</label>
                                            <input type="text" class="form-control" name="state" id="new-review-state">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col">
                                            <label for="new-review-body">Testimonial</label>
                                            <textarea class="review-body-input form-control" id="new-review-body" name="body"></textarea>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col">
                                            <div class="rating-label">
                                                <label>Overall Testimonial Rating</label>
                                                <p>Click to select rating</p>
                                            </div>
                                            <input type="hidden" class="form-control" name="rating" id="new-review-rating">
                                            <div>
                                                <div id="new-review-rating-stars">
                                                    <button type="button" class="star-buttons active" data-rating="1">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                    <button type="button" class="star-buttons active" data-rating="2">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                    <button type="button" class="star-buttons active" data-rating="3">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                    <button type="button" class="star-buttons active" data-rating="4">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                    <button type="button" class="star-buttons active" data-rating="5">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="new-review-modal-error" class="row" style="display:none;">
                                        <div class="col alert alert-danger" style="border-radius: 4px;">
                                            <div></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <hr></hr>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <span>Cancel</span>
                        </button>
                        <button form="new-review-form" type="submit" class="btn btn-primary" id="submit-button">
                            <span id="submit-button-text">Add Review</span>
                            <span id="submit-button-spinner" class="spinner-border spinner-border-sm" role="status" aria-hidden="true" style="display: none;"></span>
                            <i id="submit-button-icon" class="bi bi-plus-circle"></i>
                        </button>
                    </div>
                </div>
            </div> 
        `;
        this.Modal = template;
        this.BSModal = new bootstrap.Modal(template);

        const form = template.querySelector<HTMLFormElement>("#new-review-form");
        const starButtons = template.querySelectorAll<HTMLButtonElement>(".star-buttons");

        form.addEventListener("submit", (e) => {
            e.preventDefault();
            this.OnFormSubmitted();
        });

        for(const starButton of Array.from(starButtons)){
            starButton.addEventListener("click", () => {
                this.OnStarButtonClicked(starButton);
            });
        }

        this.Modal.addEventListener('hidden.bs.modal', () => {
            this.ResetForm();
        });

        return this;
    }

    private OnStarButtonClicked(starButton: HTMLButtonElement): void{

        const rating = parseInt(starButton.getAttribute("data-rating"));
        this.LastRatingClickedOn = rating;

        for(let i = 1; i <= 5; i++){
            const currentButton = this.Modal.querySelector<HTMLButtonElement>(`.star-buttons[data-rating="${i}"]`);
            if(i <= rating){
                currentButton.classList.add("active");
            }else{
                currentButton.classList.remove("active");
            }
        }
    }

    private async OnFormSubmitted(): Promise<void>{
        
        const submitButton = this.Modal.querySelector<HTMLButtonElement>("#submit-button");
        const submitButtonSpinner = this.Modal.querySelector<HTMLSpanElement>("#submit-button-spinner");
        const submitButtonText = this.Modal.querySelector<HTMLSpanElement>("#submit-button-text");
        const submitButtonIcon = this.Modal.querySelector<HTMLElement>("#submit-button-icon");

        submitButton.disabled = true;
        submitButtonSpinner.style.display = "inline-block";
        submitButtonText.textContent = "Loading...";
        submitButtonIcon.style.display = "none";

        const payload = {
            "first-name": this.Modal.querySelector<HTMLInputElement>("#new-review-first-name").value,
            "last-name": this.Modal.querySelector<HTMLInputElement>("#new-review-last-name").value,
            "city": this.Modal.querySelector<HTMLInputElement>("#new-review-city").value,
            "state": this.Modal.querySelector<HTMLInputElement>("#new-review-state").value,
            "body": this.Modal.querySelector<HTMLTextAreaElement>("#new-review-body").value,
            "rating": this.LastRatingClickedOn
        };

        const response: Response = await fetch("/uplift/reviews", {
            method: "PUT",
            body: JSON.stringify(payload),
            headers: new Headers({
                "content-type": "application/json"
            })
        });

        await Scheduler.Wait(700);
        const apiResponse = await response.json();
        
        if("error" in apiResponse){
            const errorContainer = this.Modal.querySelector<HTMLDivElement>("#new-review-modal-error");
            const errorMessage = apiResponse.error;

            errorContainer.style.display = null;
            errorContainer.querySelector("div").textContent = errorMessage;

        } else{
            this.ResetForm();
            this.Hide();
            this.ManageReviewsInstance.LoadReviews();
        }

        submitButton.disabled = false;
        submitButtonSpinner.style.display = "none";
        submitButtonIcon.style.display = "inline-block";
        submitButtonText.textContent = "Add a Review";
    
    }
    
    private ResetForm(): void {
        const form = this.Modal.querySelector<HTMLFormElement>("#new-review-form");
        const errorContainer = this.Modal.querySelector<HTMLDivElement>("#new-review-modal-error");
        form.reset();
        this.LastRatingClickedOn = 5;
        errorContainer.style.display = "none";

        for (let i = 1; i <= 5; i++) {
            const starButton = this.Modal.querySelector<HTMLButtonElement>(`.star-buttons[data-rating="${i}"]`);
            
            if(i <= 5){
                starButton.classList.add("active");
            } else{
                starButton.classList.remove("active");
            }
        }
    }
}