import { BaseModal } from "../../Bases/BaseModal";
import { Scheduler } from "../../Utils/Scheduler";
import { ManageReviews } from "../ManageReviews";
import { Review } from "../Components/Review";

export class DeleteReviewModal extends BaseModal{

    private ManageReviewsInstance: ManageReviews;
    public ReviewComponent: Review;

    public constructor(manageReviewsInstance: ManageReviews){
        super();
        this.ManageReviewsInstance = manageReviewsInstance;
    }

    public override Build(): this{
        const template = document.createElement("div");
        template.classList.add("modal");
        template.setAttribute("id", "delete-review-modal");
        template.innerHTML = `
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2 class="modal-title h4 mb-0">Delete Review</h2>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div id="delete-review-error" class="alert alert-danger" style="display: none; border-radius: 4px;"><div><p class="mb-0">This review has already been deleted, try refreshing your page.</p></div></div>
                        <div class="caution-message d-flex">
                            <div class="caution-icon"><i class="bi bi-exclamation-triangle"></i></div>
                            <p>
                            You're about to delete a review entry. Are you sure you want to proceed?
                            </p>
                        </div>
                        <hr>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <span>Cancel</span>
                        </button>
                        <button class="btn btn-primary" id="confirm-delete-button">
                            <span id="delete-button-text">Delete</span>
                            <span id="delete-button-spinner" class="spinner-border spinner-border-sm" role="status" aria-hidden="true" style="display: none;"></span>
                        </button>
                    </div>
                </div>
            </div> 
        `;
        this.Modal = template;
        this.BSModal = new bootstrap.Modal(template);

        template.querySelector("#confirm-delete-button").addEventListener("click", () => {
            this.ConfirmDelete();
        });

        return this;
    }

    private async ConfirmDelete(){

        const deleteButton = this.Modal.querySelector<HTMLButtonElement>("#confirm-delete-button");
        const deleteButtonSpinner = this.Modal.querySelector<HTMLSpanElement>("#delete-button-spinner");
        const deleteButtonText = this.Modal.querySelector<HTMLSpanElement>("#delete-button-text");

        deleteButton.disabled = true;
        deleteButtonSpinner.style.display = "inline-block";
        deleteButtonText.textContent = "Deleting...";

        await Scheduler.Wait(700);

        const wasDeleted = await this.ManageReviewsInstance.DeleteReview(this.ReviewComponent);

        if(wasDeleted) {
            this.Hide();
        }

        deleteButton.disabled = false;
        deleteButtonSpinner.style.display = "none";
        deleteButtonText.textContent = "Delete";
    }
}