import { EndpointsProvider } from "../../EndpointsProvider";
import { NewReviewModal } from "../Modals/NewReviewModal";
import { ManageReviews } from "../ManageReviews";

export class SearchReviewsForm {

	private ManageReviewsInstance: ManageReviews;
	public IsProcessing: boolean = false;
	public Form: HTMLFormElement;

	constructor() {
		this.IsProcessing = false;
		/**
		 * Starts the form and adds an event listener that runs when the form is submitted. 
		 */
		this.Form = document.querySelector("#review-search-form");

		this.Form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		});
	}

	public async OnSubmit() {
		/**
		 * Prevents multiple form submissions if one is in progress. 
		 */
		if (this.IsProcessing) {
			return;
		}

		this.IsProcessing = true;

		const fData = new FormData(this.Form);
		const query = fData.get("query") as string;

		this.ManageReviewsInstance.CurrentPage = 1;
		this.ManageReviewsInstance.CurrentQuery = query;
		
		/**
		 * Loads reviews based on current page, limit, and query. 
		 */
		await this.ManageReviewsInstance.LoadReviews(
			this.ManageReviewsInstance.CurrentPage,
			this.ManageReviewsInstance.CurrentLimit,
			this.ManageReviewsInstance.CurrentQuery
		);

		this.IsProcessing = false;
	}
}