import { EndpointsProvider } from "../../EndpointsProvider";
import { ManageRedirects } from "../ManageRedirects";


export class EditRedirectForm{
    private Form = document.querySelector<HTMLFormElement>("#edit-redirect-form");
    private IsProcessing: boolean = false;
	private ManageRedirectsInstance: ManageRedirects;
	public CurrentRedirectID: number | null = null;

    public constructor(manageRedirectsInstance: ManageRedirects){
		this.ManageRedirectsInstance = manageRedirectsInstance;
        this.Form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		});
    }
	/**
	 * Handles form submission 
	 * @returns 
	 */
    private async OnSubmit(): Promise<void>{
        if (this.IsProcessing){
			return;
		}

		this.IsProcessing = true;

		const response = await fetch(`${EndpointsProvider.EndPoints.Redirects.EditRedirect}/${this.CurrentRedirectID}`, {
		    body:new FormData(this.Form),
		    method:"PATCH",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data: {status: number, error?: string};
		try{
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			return;
		}

		if (data.status === 1){
			this.Form.reset();
			this.ManageRedirectsInstance.EditRedirectModal.HideModal();
			this.ManageRedirectsInstance.LoadRedirects(
				this.ManageRedirectsInstance.CurrentPage,
				this.ManageRedirectsInstance.CurrentLimit,
				this.ManageRedirectsInstance.CurrentQuery
			);
		}else if (data.status === -1){
			alert(data.error);
		}

		this.IsProcessing = false;
    }
}