import {FindAndReplace} from "../FindAndReplace";
import {Scheduler} from "../../Utils/Scheduler";
import { MakeReplacementsDto } from "../Interfaces/MakeReplacementsDto";

/**
 * Currently, this is only to prevent the page refreshing if the user hits enter in the replacement field
 */
export class ReplaceForm{
    private IsProcessing: boolean = false;
    private FindAndReplaceInstance: FindAndReplace;

    public Form: HTMLFormElement | null = document.querySelector("#replace-form");

    public constructor(findAndReplaceEntryInstance: FindAndReplace){
        this.FindAndReplaceInstance = findAndReplaceEntryInstance;
        this.Form.addEventListener("submit", e => {
			e.preventDefault();
            this.OnFormSubmit();
		});
    }

    /**
     * Called when the replace all occurrences form is submitted. This will
     * package up a MakeReplacementsDto payload object and send the request to
     * PATCH /uplift/find-and-replace/make-replacements
     */
    public async OnFormSubmit(): Promise<void>{
        if (this.IsProcessing){
            return;
        }

        // Check if the search input was changed since they last did a Find operation
        if (this.FindAndReplaceInstance.SearchForm.SearchInputChangedSinceLastSubmission){
            alert("You have changed your search input since the last Find operation. You should re-run the Find operation before trying to make a replacement.");
            return;
        }

        this.IsProcessing = true;
        this.FindAndReplaceInstance.ReplaceAllLoaderContainer.style.display = null;
        this.FindAndReplaceInstance.MainAppContainer.style.display = "none";

        await Scheduler.Wait(1000);

        // TODO
        // Call API code and stuff

        const replacementInput = document.querySelector("#replacement-input");
        const replacementText = replacementInput instanceof HTMLInputElement ? replacementInput.value : "";
        
        // Locates results from CurrentPageResults and adds them to foundPages
        const foundPages = [];
        for (const result of this.FindAndReplaceInstance.CurrentPageResults) {
            foundPages.push(result.OriginalResult);
        }
        // Locates file results from CurrentFileResults and adds them to foundFiles
        const foundFiles = [];
        for (const result of this.FindAndReplaceInstance.CurrentFileResults) {
            foundFiles.push(result.OriginalResult);
        }
        // Prepares replacement payload
        const payload: MakeReplacementsDto = {
            findAndReplaceFoundDto: {
                foundPagesMatches: {
                    foundPages: foundPages,
                },
                foundFiles: foundFiles,
            },
            // Looks at user entered query
            originalQuery: this.FindAndReplaceInstance.SearchForm.FindAndReplaceEntryInstance.LastQueryUsed,
            // Enters replacement text
            replacement: replacementText,
        };
        // Sends new replacement text to server
        const response = await fetch(`/uplift/find-and-replace/make-replacements`, {
            body: JSON.stringify(payload),
            method: "PATCH",
            headers: { "Content-Type": "application/json" },
        });
        // Process the server's response
        const data = await response.json();

        // Handles the response
        if (data.status === 1) {
            alert("All occurrences have been replaced successfully.");
            this.FindAndReplaceInstance.CurrentPageResults = [];
        } else if (data.status === -1) {
            alert("An error occurred during replacement.");
        } else {
            alert("An unexpected error occurred.");
        }
        
        this.IsProcessing = false;
        this.FindAndReplaceInstance.ReplaceAllLoaderContainer.style.display = "none";
        this.FindAndReplaceInstance.MainAppContainer.style.display = null
    }
}