export default class CityPageSelectMenu{
    public cityPageIDSelectInput: HTMLSelectElement = document.querySelector("#city-page-id-input");
    public customProjectSelectionFieldsContainer: HTMLDivElement = document.querySelector("#custom-project-location-fields");

    constructor() {
        this.cityPageIDSelectInput.addEventListener("change", () => {
            this.onCityPageIDSelectChanged();
        });
    }

    onCityPageIDSelectChanged(){
        if (this.cityPageIDSelectInput.value === "-1"){
            this.showCustomLocationFields();
        }else{
            this.hideCustomLocationFields();
        }
    }

    showCustomLocationFields(){
        this.customProjectSelectionFieldsContainer.style.display = null;
    }

    hideCustomLocationFields(){
        this.customProjectSelectionFieldsContainer.style.display = "none"
    }
}