import { Modal } from "bootstrap";

export class BaseModal{

    protected Modal: HTMLElement;
    protected BSModal: Modal;

    public Show(): this{
        this.BSModal.show();
        return this;
    }

    public Hide(): this{
        this.BSModal.hide();
        return this;
    }

    public Build(): this{
        throw "Not implemented";
    }

    public RenderInto(container: HTMLElement): this{
        container.append(this.Modal);
        return this;
    }

    public GetModal(): HTMLElement{
        return this.Modal;
    }

    public GetBSModal(): Modal{
        return this.BSModal;
    }
}