import ConfirmModal from "../../utils/ConfirmModal.js";
import UserAccounts from "../UserAccounts.js";
import Endpoints from "../../Endpoints.js";

class Account {

	static accountsContainer = document.querySelector("#users-rows-container");

	dom = null;
	id;
	username;
	firstName;
	lastName;
	role;
	lastActivity;

	/**
	 * @param {int} id
	 * @param {string} username
	 * @param {string} firstName
	 * @param {string} lastName
	 * @param {string} role
	 * @param {int} lastActivity
	 */
	constructor(id, username, firstName, lastName, role, lastActivity){
		this.id = id;
		this.username = username;
		this.firstName = firstName;
		this.lastName = lastName;
		this.role = role;
		this.lastActivity = lastActivity;
		this.dom = this.getDOM();

		Account.accountsContainer.append(this.dom);
	}

	/**
	 * @returns {HTMLElement}
	 */
	getDOM(){
		let dateString;
		let nameString = this.firstName;

		if (this.lastName.length > 0){
			nameString += ` ${this.lastName}`;
		}

		if(this.lastActivity !== null) {
			dateString = (new Date(this.lastActivity * 1000)).toLocaleDateString();
		} else {
			dateString = "N/A";
		}

		const template = document.createElement("user-row");
		template.classList.add("users-columns");
		template.innerHTML = `
			<div class="username">
				<span>${this.username}</span>
			</div>
			<div class="name">
				<span>${nameString}</span>
			</div>
			<div class="role">
				<span>${this.role}</span>
			</div>
			<div class="last-activity">
				<span>${dateString}</span>
			</div>
			<div class="management-buttons">
				<a href="/uplift/manage-user-accounts/${this.id}" class="btn btn-sm btn-primary">
					<i class="bi bi-person-video2"></i>
					<span>Manage</span>
				</a>
			</div>
		`;

		return template;
	}
}

export default Account;