export class ThemeItem {
	themeImporter;
	themeData;
	themeManagerUrl;
	dom;

	constructor(themeImporter, themeData, themeManagerUrl) {
		this.themeImporter = themeImporter;
		this.themeData = themeData;
		this.themeManagerUrl = themeManagerUrl;
	}

	build() {
		const template = document.createElement("div");
		const themeName = this.themeData.Name.charAt(0).toUpperCase() + this.themeData.Name.slice(1);
		const themeUrl = this.themeManagerUrl + this.themeData.ZipFile;
		const featuredImage = this.themeManagerUrl + this.themeData.FeaturedImage;

		template.classList.add("theme");
		template.innerHTML = `
			<div class="image-container">
				<i class="bi bi-search"></i>
				<img src="${featuredImage}" alt="${themeName}" class="featured-image">
			</div>
			<div class="content-container">
				<span class="d-block h3 mb-3">${themeName}</span>
				<button type="button" class="btn btn-primary" id="install-button" theme-url="${themeUrl}">Install Theme</button>
			</div>
		`;

		const installThemeButton = template.querySelector("#install-button");
		const imageContainer = template.querySelector(".image-container");

		installThemeButton.addEventListener("click", () => {
			this.themeImporter.downloadTheme(themeUrl);
		});

		imageContainer.addEventListener("click", () => {
			window.open(featuredImage, '_blank');
		});

		this.dom = template;
		return this;
	}

	renderInto(container) {
		container.append(this.dom);
		return this;
	}
}