import Endpoints from "../../Endpoints.js";
import PhoneNumber from "../components/PhoneNumber.js";
import FaxNumber from "../components/FaxNumber.js";
import AdditionalAddress from "../components/AdditionalAddress.js";
import Scheduler from "../../utils/Scheduler.js";

class CompanyInformationForm{

	/**
	 * @type {HTMLFormElement}
	 */
	form;
	/**
	 * @type {HTMLButtonElement}
	 */
	submitButton
	/**
	 * @type {boolean}
	 */
	isSubmitting = false;

	constructor(){
		this.form = document.querySelector("#company-information-form");
		this.submitButton = this.form.querySelector(`button[type="submit"]`);
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});

		// TODO: This should be in its own function and the function should combine the icon/image uploads
		this.logoInput = this.form.querySelector('#company-logo-input');
		this.logoInput.addEventListener('change', function() {
			let file = this.files[0];
			let previewImage = this.form.querySelector('#logo-preview');

			if(file) {
				let errorContainer = this.form.querySelector("#image-error");
				let maxSizeInMB = this.getAttribute("data-max-size-in-mb");
				let fileSizeInMB = file.size/1000000;
				let fileSizeInKB = file.size/1000;
				let readableMaxSize = "";

				errorContainer.style.display = "none";

				if (maxSizeInMB < 1){
					readableMaxSize = (maxSizeInMB * 1000) + "KB";
				}else{
					readableMaxSize = maxSizeInMB + "M";
				}

				if (fileSizeInMB > maxSizeInMB){
					errorContainer.style.display = "block";
					errorContainer.innerHTML = "The file size for this field restricts uploads to be under " + readableMaxSize + ".";
				}else{
					previewImage.src = URL.createObjectURL(this.files[0]);
				}
			}
		});

		this.faviconInput = this.form.querySelector('#company-favicon-input');
		this.faviconInput.addEventListener('change', function() {
			let file = this.files[0];
			let previewImage = this.form.querySelector('#favicon-preview');

			if(file) {
				let errorContainer = this.form.querySelector("#image-error");
				let maxSizeInMB = this.getAttribute("data-max-size-in-mb");
				let fileSizeInMB = file.size/1000000;
				let fileSizeInKB = file.size/1000;
				let readableMaxSize = "";

				errorContainer.style.display = "none";

				if (maxSizeInMB < 1){
					readableMaxSize = (maxSizeInMB * 1000) + "KB";
				}else{
					readableMaxSize = maxSizeInMB + "M";
				}

				if (fileSizeInMB > maxSizeInMB){
					errorContainer.style.display = "block";
					errorContainer.innerHTML = "The file size for this field restricts uploads to be under " + readableMaxSize + ".";
				}else{
					previewImage.src = URL.createObjectURL(this.files[0]);
				}
			}
		});
	}

	/**
	 * Fired when the form is submitted.
	 */
	async onSubmit(){
		if (this.isSubmitting){
			return;
		}

		this.isSubmitting = true;
		this.submitButton.querySelector("span").textContent = "Saving...";
		this.submitButton.classList.add("disabled");

		const fData = new FormData(this.form);

		// Inject phone and fax numbers
		if (PhoneNumber.cache.length > 0) {
			fData.set("phone-numbers", JSON.stringify(PhoneNumber.getNumbers()));
		}else{
			fData.set("phone-numbers", "[]");
		}

		if (FaxNumber.cache.length > 0) {
			fData.set("fax-numbers", JSON.stringify(FaxNumber.getNumbers()));
		}else{
			fData.set("fax-numbers", "[]");
		}

		// Send additional addresses as a JSON string. We can't use a JSON payload here because we're also
		// sending file contents in the FormData
		const additionalAddresses = [];
		for (const additionalAddress of AdditionalAddress.cache){
			additionalAddresses.push(additionalAddress.getDataAsArray());
		}

		fData.set("additional-addresses-json", JSON.stringify(additionalAddresses));

		const response = await fetch(`/uplift/settings/company-information`, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"PATCH"
		});

		await Scheduler.wait(150);

		if (response.status === 200){
			const data = await response.json();
			if (data.status === 1){

			}else if (data.status === -1){
				console.warn(data.error);
			}
		}else{
			console.warn(await response.text());
		}

		this.submitButton.querySelector("span").textContent = "Save Company Information";
		this.submitButton.classList.remove("disabled");
		this.isSubmitting = false;
	}
}

export default new CompanyInformationForm;
