import Scheduler from "../../utils/Scheduler.js";

class UpdateCoreButton{
	isProcessing = false;
	button = document.querySelector("#update-core-button");

	constructor() {
		if (this.button !== null) {
			this.button.addEventListener("click", () => {
				this.onClick();
			});

			window.addEventListener("beforeunload", e => {
				this.onWindowBeforeUnload(e);
			});
		}
	}

	showAsLoading(){
		this.button.classList.add("disabled");
		this.button.querySelector("#update-cloud-icon").style.display = "none";
		this.button.querySelector("#update-spinner").style.display = null;
		this.button.querySelector("#update-verbiage").textContent = `Updating...`;
	}

	showAsNormal(){
		this.button.classList.remove("disabled");
		this.button.querySelector("#update-cloud-icon").style.display = null;
		this.button.querySelector("#update-spinner").style.display = "none";
		this.button.querySelector("#update-verbiage").textContent = `Update`;
	}

	onWindowBeforeUnload(e){
		if (this.isProcessing){
			e.preventDefault();
			e.returnValue = "Updating";
			return false;
		}
	}

	async onClick(){

		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.showAsLoading();

		const response = await fetch(`/uplift/updater/update-core`, {
		    method:"GET",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			this.showAsNormal();
		    return;
		}

		await Scheduler.wait(600);

		if (data.status === 1){
			// Send a request to perform the post-update

			// TODO catch errors
			const postUpdateResponse = await fetch(`/uplift/updater/run-post-update-processes`, {
				credentials:"same-origin"
			});

			if (postUpdateResponse.status !== 200){
				alert("Post update failed.")
			}

			window.location.reload();
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.showAsNormal();
	}
}

export default new UpdateCoreButton();