import Scheduler from "../../utils/Scheduler.js";

class ReRegisterBuildButton{
	button = document.querySelector("#reregister-build-button");
	isProcessing = false;
	successContainer = document.querySelector("#register-success-container");
	uuidContainer = document.querySelector("#build-uuid");
	apiKeyContainer = document.querySelector("#build-api-key");

	constructor(){
		this.button.addEventListener("click", () => {
			this.onButtonClick();
		});
	}

	async onButtonClick(){
		if (this.isProcessing) {
			return;
		}

		this.isProcessing = true;
		this.button.classList.add("disabled");

		const response = await fetch(`/uplift/settings/re-register-build`, {
			body: null,
			method: "GET",
			cache: "no-cache",
			credentials: "same-origin"
		});

		let data;
		try {
			/** @type {{status: int, error: ?string, uuid: string, apiKey: string}} **/
			data = await response.json();
		} catch (jsonSyntaxError) {
			alert("The server responded with invalid JSON.");
			this.button.classList.remove("disabled");
			this.isProcessing = false;
			return;
		}

		if (data.status === 1) {
			this.successContainer.style.display = null;
			this.uuidContainer.textContent = data.uuid;
			this.apiKeyContainer.textContent = data.apiKey;
			await Scheduler.wait(2000);
			this.successContainer.style.display = "none";
		} else if (data.status === -1) {
			alert(data.error);
		}

		this.isProcessing = false;
		this.button.classList.remove("disabled");
	}
}

export default new ReRegisterBuildButton();