import AddPhoneNumberButton from "./AddPhoneNumberButton.js";

class PhoneNumber{

	/** @type {PhoneNumber[]} */
	static cache = [];
	static container = document.querySelector("#phone-numbers");

	number = null;
	dom = null;

	/**
	 * Fetches only the numbers from the cache
	 */
	static getNumbers(){
		const a = [];
		for (const component of PhoneNumber.cache){
			a.push(component.number);
		}

		return a;
	}

	/**
	 * Updates the components index element to represent the correct "whichIndex"
	 * as well as the property of the component object.
	 */
	static updateComponentIndices(){
		for (let arrayIndex in PhoneNumber.cache){
			const component = PhoneNumber.cache[arrayIndex];
			arrayIndex = parseInt(arrayIndex);
			component.whichIndex = arrayIndex + 1;
			component.dom.querySelector(".index-label > span").textContent = String(component.whichIndex);
		}
	}

	/**
	 * @param {string | null} number
	 */
	constructor(number){
		this.whichIndex = PhoneNumber.cache.length + 1;
		this.number = number;
		this.dom = this.getDOM();

		PhoneNumber.container.append(this.dom);
		PhoneNumber.cache.push(this);
	}

	remove(){
		for (let arrayIndex in PhoneNumber.cache){
			const button = PhoneNumber.cache[arrayIndex];
			arrayIndex = parseInt(arrayIndex);
			if (button.whichIndex === this.whichIndex){
				PhoneNumber.cache.splice(arrayIndex, 1);
				break;
			}
		}

		this.dom.remove();
		PhoneNumber.updateComponentIndices();

		if (PhoneNumber.cache.length === 0){
			// Show the "no numbers" container
			AddPhoneNumberButton.noPhoneNumberMessage.style.display = null;
		}
	}

	/**
	 * @returns {HTMLDivElement}
	 */
	getDOM(){
		const template = document.createElement("div");
		template.classList.add("settings-phone-number-component");
		template.innerHTML = `
			<div>
				<div class="index-label">
					<span>${this.whichIndex}</span>
				</div>
				<div class="input-container">
					<div class="input-group">
						<span class="input-group-text"><i class="bi bi-telephone-fill"></i></span>
						<input type="text" class="form-control">
					</div>
				</div>
				<div class="delete-button-container">
					<button type="button" class="btn btn-danger">
						<i class="bi bi-trash-fill"></i>
						<span>Delete</span>
					</button>
				</div>
			</div>
		`;

		const inputField = template.querySelector(".input-container input");

		if (this.number !== null){
			inputField.value = this.number;
		}

		const deleteButton = template.querySelector(".delete-button-container > button");
		deleteButton.addEventListener("click", () => {
			this.remove();
		});

		inputField.addEventListener("input", () => {
			this.number = inputField.value;
		});

		return template;
	}
}

export default PhoneNumber;