import AddFaxNumberButton from "./AddFaxNumberButton.js";

class FaxNumber{

	/** @type {FaxNumber[]} */
	static cache = [];
	static container = document.querySelector("#fax-numbers");

	number = null;
	dom = null;

	/**
	 * Fetches only the numbers from the cache
	 */
	static getNumbers(){
		const a = [];
		for (const component of FaxNumber.cache){
			a.push(component.number);
		}

		return a;
	}

	/**
	 * Updates the components index element to represent the correct "whichIndex"
	 * as well as the property of the component object.
	 */
	static updateComponentIndices(){
		for (let arrayIndex in FaxNumber.cache){
			const component = FaxNumber.cache[arrayIndex];
			arrayIndex = parseInt(arrayIndex);
			component.whichIndex = arrayIndex + 1;
			component.dom.querySelector(".index-label > span").textContent = String(component.whichIndex);
		}
	}

	/**
	 * @param {string | null} number
	 */
	constructor(number){
		this.whichIndex = FaxNumber.cache.length + 1;
		this.number = number;
		this.dom = this.getDOM();

		FaxNumber.container.append(this.dom);
		FaxNumber.cache.push(this);
	}

	remove(){
		for (let arrayIndex in FaxNumber.cache){
			const button = FaxNumber.cache[arrayIndex];
			arrayIndex = parseInt(arrayIndex);
			if (button.whichIndex === this.whichIndex){
				FaxNumber.cache.splice(arrayIndex, 1);
				break;
			}
		}

		this.dom.remove();
		FaxNumber.updateComponentIndices();

		if (FaxNumber.cache.length === 0){
			// Show the "no numbers" container
			AddFaxNumberButton.noFaxNumberMessage.style.display = null;
		}
	}

	/**
	 * @returns {HTMLDivElement}
	 */
	getDOM(){
		const template = document.createElement("div");
		template.classList.add("settings-fax-number-component");
		template.innerHTML = `
			<div>
				<div class="index-label">
					<span>${this.whichIndex}</span>
				</div>
				<div class="input-container">
					<div class="input-group">
						<span class="input-group-text"><i class="bi bi-telephone-fill"></i></span>
						<input type="text" class="form-control">
					</div>
				</div>
				<div class="delete-button-container">
					<button type="button" class="btn btn-danger">
						<i class="bi bi-trash-fill"></i>
						<span>Delete</span>
					</button>
				</div>
			</div>
		`;

		const inputField = template.querySelector(".input-container input");

		if (this.number !== null){
			inputField.value = this.number;
		}

		const deleteButton = template.querySelector(".delete-button-container > button");
		deleteButton.addEventListener("click", () => {
			this.remove();
		});

		inputField.addEventListener("input", () => {
			this.number = inputField.value;
		});

		return template;
	}
}

export default FaxNumber;