class AdditionalAddress{

	/** @type {AdditionalAddress[]} */
	static cache = [];
	static container = document.querySelector("#additional-addresses");

	static removeInstance(instance){
		instance.dom.remove();

		for (const [index, value] of AdditionalAddress.cache.entries()){
			if (value === instance){
				AdditionalAddress.cache.splice(index, 1);
				break;
			}
		}
	}

	id;
	dom;

	constructor(id) {
		this.id = id;
		this.dom = this.getDOM();
		this.constructor.cache.push(this);
	}

	render(){
		AdditionalAddress.container.append(this.dom);
	}

	/**
	 * Converts the address fields into an array with the following keys
	 * street, city, state, postal, country
	 * @return {{street: string, city: string, state: string, postal: string, country: string}}
	 */
	getDataAsArray(){
		const street = this.dom.querySelector(".additional-street-input").value;
		const city = this.dom.querySelector(".additional-city-input").value;
		const state = this.dom.querySelector(".additional-state-input").value;
		const postal = this.dom.querySelector(".additional-postal-input").value;
		const country = this.dom.querySelector(".additional-country-input").value;

		return {
			street: street,
			city: city,
			state: state,
			postal: postal,
			country: country
		};
	}

	/**
	 * Loads existing address data into this instance
	 * @param {string} street
	 * @param {string} city
	 * @param {string} state
	 * @param {string} postal
	 * @param {string} country
	 */
	loadExistingData(
		street,
		city,
		state,
		postal,
		country
	){
		this.dom.querySelector(".additional-street-input").value = street;
		this.dom.querySelector(".additional-city-input").value = city;
		this.dom.querySelector(".additional-state-input").value = state;
		this.dom.querySelector(".additional-postal-input").value = postal;
		this.dom.querySelector(".additional-country-input").value = country;
	}

	getDOM(){
		const template = document.createElement("div");
		template.classList.add("additional-address-container");
		template.innerHTML = `
			<div class="card">
				<div class="card-header">
					<h4 class="mb-0">Additional Address</h4>
				</div>
				<div class="card-body">
					<div class="my-2">
						<label for="">Additional Street</label>
						<div class="input-group">
							<span class="input-group-text"><i class="bi bi-geo-fill"></i></span>
							<input type="text" autocomplete="offf" class="form-control form-control-sm additional-street-input">
						</div>
					</div>
					<div class="my-2">
						<label for="">Additional City</label>
						<div class="input-group">
							<span class="input-group-text"><i class="bi bi-geo-fill"></i></span>
							<input type="text" autocomplete="offf" class="form-control form-control-sm additional-city-input">
						</div>
					</div>
					<div class="container-fluid p-0">
						<div class="row my-2">
							<div class="col-xl">
								<label for="">Additional State (abbr.)</label>
								<div class="input-group">
									<span class="input-group-text"><i class="bi bi-geo-fill"></i></span>
									<input type="text" autocomplete="offf" class="form-control form-control-sm additional-state-input">
								</div>
							</div>
							<div class="col-xl">
								<label for="">Additional Postal</label>
								<div class="input-group">
									<span class="input-group-text"><i class="bi bi-geo-fill"></i></span>	
									<input type="text" autocomplete="offf" class="form-control form-control-sm additional-postal-input">
								</div>
							</div>
						</div>
					</div>
					<div class="my-2">
						<label for="">Country (abbr.)</label>
						<div class="input-group">
							<span class="input-group-text"><i class="bi bi-geo-fill"></i></span>
							<input type="text" autocomplete="offf" class="form-control form-control-sm additional-country-input">
						</div>
					</div>
					<hr>
					<div class="mt-2">
						<button class="delete-button btn btn-sm btn-danger">
							<i class="bi bi-trash-fill"></i>
							<span>Remove Address</span>
						</button>
					</div>
				</div>
			</div>
		`;

		const deleteButton = template.querySelector(".delete-button");
		deleteButton.addEventListener("click", () => {
			this.onDeleteButtonClicked();
		});

		return template;
	}

	onDeleteButtonClicked(){
		AdditionalAddress.removeInstance(this);
	}
}

export default AdditionalAddress;