import CompanyInformationForm from "./forms/CompanyInformationForm.js";
import UpliftSettingsForm from "./forms/UpliftSettingsForm.js";
import ContentSettingsForm from "./forms/ContentSettingsForm.js";
import RobotSettingsForm from "./forms/RobotSettingsForm.js";
import InjectionsForm from "./forms/InjectionsForm.js";
import AddPhoneNumberButton from "./components/AddPhoneNumberButton.js";
import PhoneNumber from "./components/PhoneNumber.js";
import AddFaxNumberButton from "./components/AddFaxNumberButton.js";
import FaxNumber from "./components/FaxNumber.js";
import UpdateCoreButton from "./components/UpdateCoreButton.js";
import ReRegisterBuildButton from "./components/ReRegisterBuildButton.js";
import AddAddressButton from "./components/AddAddressButton.js";
import AdditionalAddress from "./components/AdditionalAddress.js";

class Settings {

	phoneNumbersJSONContainer = document.querySelector("#phone-numbers-initial-load-json");
	faxNumbersJSONContainer = document.querySelector("#fax-numbers-initial-load-json");
	additionalAddressesJSONContainer = document.querySelector("#additional-addresses-initial-load-json");

	constructor() {
		window.addEventListener("keydown", e => {
			if (e.ctrlKey) {
				if (e.key.toLowerCase() === "s") {
					e.preventDefault();

					// Save all forms
					CompanyInformationForm.onSubmit();
					UpliftSettingsForm.onSubmit();
					ContentSettingsForm.onSubmit();
					RobotSettingsForm.onSubmit();
				}
			}
		});

		this.loadExistingPhoneNumbers();
		this.loadExistingFaxNumbers();
		this.loadExistingAdditionalAddresses();

		new AddAddressButton();
	}

	loadExistingPhoneNumbers(){
		try {
			const phoneNumbers = JSON.parse(this.phoneNumbersJSONContainer.textContent);

			if (phoneNumbers.length > 0){
				AddPhoneNumberButton.noPhoneNumberMessage.style.display = "none";
			}

			for (const number of phoneNumbers){
				new PhoneNumber(number);
			}
		}catch(jsonError){

		}
	}

	loadExistingFaxNumbers(){
		try {
			const faxNumbers = JSON.parse(this.faxNumbersJSONContainer.textContent);

			if (faxNumbers.length > 0){
				AddFaxNumberButton.noFaxNumberMessage.style.display = "none";
			}

			for (const number of faxNumbers){
				new FaxNumber(number);
			}
		}catch(jsonError){

		}
	}

	loadExistingAdditionalAddresses(){
		try {
			const additionalAddressCustomSettings = JSON.parse(this.additionalAddressesJSONContainer.textContent);

			/**
			 * The 'value' is a JSON string. Must be parsed.
			 * @type {{id: int, name: string, value: string}}
			 */
			for (const additionalAddressCustomSetting of additionalAddressCustomSettings){
				/**
				 * @type {{street: string, city: string, state: string, postal: string, country: string}}
				 */
				const address = JSON.parse(additionalAddressCustomSetting.value);
				const additionalAddressInstance = new AdditionalAddress(additionalAddressCustomSetting.id);
				additionalAddressInstance.render();
				additionalAddressInstance.loadExistingData(
					address.street,
					address.city,
					address.state,
					address.postal,
					address.country
				);
			}
		}catch(jsonError){

		}
	}
}

export default new Settings;