import Scheduler from "../../utils/Scheduler.js";
import ContentBuildForm from "./ContentBuildForm.js";
import SenzuImporter from "../SenzuImporter.js";
import PageComponent from "../components/PageComponent.js";

class SenzuFetchForm{
	isProcessing = false;
	form = document.querySelector("#senzu-content-fetch-form");
	button = document.querySelector("#site-fetch-button");
	buttonLoader = document.querySelector("#site-fetch-button-spinner");
	buttonIcon = document.querySelector("#site-fetch-button-icons");

	constructor() {
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.button.classList.add("disabled");
		this.buttonLoader.style.display = null;
		this.buttonIcon.style.display = "none";
		ContentBuildForm.noPagesMessages.City.style.display = "none";

		const fData = new FormData(this.form);
		const urlSearchParams = new URLSearchParams();
		urlSearchParams.set("site-id", String(fData.get("site-id")));

		const response = await fetch(`/uplift/senzu-importer/get-content?${urlSearchParams.toString()}`, {
		    method:"GET",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		await Scheduler.wait(500);

		let data;
		try{
		    /** @type {{status: int, error: ?string, contentData: Object}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
		    return;
		}

		if (data.status === 1){
			SenzuImporter.unsavedChanges = true;

			/** @type {{pages:Object[], data:Object}} */
			const contentData = data.contentData;

			// Sort the pages alphabetically
			contentData.pages.sort( (a,b) => {
				return a.pageName.toLowerCase() > b.pageName.toLowerCase() ? 1 : -1;
			});

			for (const page of contentData.pages){
				new PageComponent(page);
			}

			if (PageComponent.getPagesOfType("General").length === 0){
				ContentBuildForm.noPagesMessages.General.style.display = null;
			}

			if (PageComponent.getPagesOfType("Service").length === 0){
				ContentBuildForm.noPagesMessages.Service.style.display = null;
			}

			if (PageComponent.getPagesOfType("City").length === 0){
				ContentBuildForm.noPagesMessages.City.style.display = null;
			}

			if (PageComponent.getPagesOfType("Blog").length === 0){
				ContentBuildForm.noPagesMessages.Blog.style.display = null;
			}

			if (PageComponent.getPagesOfType("Project").length === 0){
				ContentBuildForm.noPagesMessages.Project.style.display = null;
			}

			ContentBuildForm.show();
			this.hide();
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.button.classList.remove("disabled");
		this.buttonLoader.style.display = "none";
		this.buttonIcon.style.display = null;
	}

	show(){
		this.form.style.display = null;
	}

	hide(){
		this.form.style.display = "none";
	}
}

export default new SenzuFetchForm();