import VirtualParent from "../components/VirtualParent.js";
import PageComponent from "../components/PageComponent.js";

class NewVirtualParentForm{
	form = document.querySelector("#manage-parents-add-virtual-parent-form");

	constructor() {

		VirtualParent.onNewVirtualParent(newVirtualComponent => {
			this.onNewVirtualParent(newVirtualComponent);
		});

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	 * @param {VirtualParent} newVirtualComponent
	 */
	onNewVirtualParent(newVirtualComponent){
		// Fires when a new virtual parent is created
		const modalSelectMenu = this.form.querySelector("select");

		// Fetch all the current virtual parents
		const vParentComponents = VirtualParent.cache;

		// Add this new component to this modal's select menu
		const option = document.createElement("option");
		option.setAttribute("value", newVirtualComponent.id);
		option.textContent = newVirtualComponent.name;
		newVirtualComponent.linkedOptions.push(option);
		modalSelectMenu.append(option);

		// Go through all page components, add an option for this new virtual parent
		for (const component of PageComponent.cache){
			const parentSelect = component.dom.querySelector(".page-parent-input");
			const option = document.createElement("option");
			option.setAttribute("value", newVirtualComponent.id);
			option.textContent = newVirtualComponent.name;
			newVirtualComponent.linkedOptions.push(option);
			parentSelect.append(option);
		}

		// Add a new option on each VirtualParent component
		for (const component of VirtualParent.cache){
			if (component.id !== newVirtualComponent.id) {
				const parentSelect = component.dom.querySelector(".virtual-parent-parent-selector");
				const option = document.createElement("option");
				option.setAttribute("value", newVirtualComponent.id);
				option.textContent = newVirtualComponent.name;
				newVirtualComponent.linkedOptions.push(option);
				parentSelect.append(option);
			}
		}
	}

	async onSubmit(){
		const fData = new FormData(this.form);

		new VirtualParent(
			fData.get("virtual-parent-name"),
			fData.get("virtual-parent-parent")
		);

		this.form.reset();
	}
}

export default new NewVirtualParentForm();