class PageData{

	static nextID = 1;
	/** @type {PageData[]} */
	static cache = [];
	static container = document.querySelector("#page-data-container");

	static clearAll(){
		for (const component of PageData.cache){
			component.dom.remove();
		}

		PageData.cache = [];
	}

	static removeByID(id){
		for (const [index, component] of PageData.cache.entries()){
			if (component.id === id){
				PageData.cache.splice(index, 1);

				// Find it in the component.pageComponent.pageDatas too
				for (const [index2, pageDatasComponent] of component.pageComponent.pageDatas.entries()){
					if (pageDatasComponent.id === id){
						component.pageComponent.pageDatas.splice(index2, 1);
						break;
					}
				}

				component.dom.remove();
				break;
			}
		}
	}

	dataType;
	dataValue;
	dom;

	/**
	 * @param {PageComponent} pageComponent
	 * @param {string} dataType
	 * @param {string} dataValue
	 */
	constructor(pageComponent, dataType, dataValue) {
		this.id = this.constructor.nextID++;
		this.pageComponent = pageComponent;
		this.dataType = dataType;
		this.dataValue = dataValue;
		this.dom = this.getDOM();

		this.constructor.cache.push(this);
		pageComponent.pageDatas.push(this);
	}

	getDOM(){
		const template = document.createElement("div");
		template.classList.add("page-parent-component");
		template.innerHTML = `
			<div class="card">
				<div class="card-header">
					<h6 class="mb-0">${this.dataType}</h6>
				</div>
				<div class="card-body">
					<div class="input-group">
						<label for="data-value-input-${this.id}" class="input-group-text">Value</label>
						<input type="text" class="form-control data-value-input" name="data-value" id="data-value-input-${this.id}" value="${this.dataValue}">
					</div>
					<div>
						<button type="button" class="btn btn-sm btn-link text-danger delete-button">
							<i class="bi bi-trash-fill"></i>
							<span>Delete</span>
						</button>
					</div>
				</div>
			</div>
		`;

		const dataValueInput = template.querySelector(".data-value-input");
		const deleteButton = template.querySelector(".delete-button");

		dataValueInput.addEventListener("input", () => {
			this.dataValue = dataValueInput.value;
		});

		deleteButton.addEventListener("click", () => {
			this.onDeleteClicked();
		});

		this.constructor.container.append(template);

		return template;
	}

	onDeleteClicked(){
		this.constructor.removeByID(this.id);
	}
}

export default PageData;