class ContentFilter {

    /**
     * Runs a filter over the text content DOM to manipulate it or add classes to content.
     *
     * @param htmlString
     * @returns {string}
     */
    static filterContent(htmlString) {

        const parser = new DOMParser();
        const htmlDoc = parser.parseFromString(htmlString, "text/html");

        const uls = htmlDoc.querySelectorAll('ul');
        uls.forEach((ul) => {
            let addClassesFlag = true;

            // Only add grid classes if the lists have more than 6 children
            if (ul.childElementCount < 6) {
                addClassesFlag = false;
            }

            // Only add grid classes if children have a character count of 35 or less
            const listItems = ul.getElementsByTagName('li');
            for (const li of listItems) {
                if (li.textContent.length > 35) {
                    addClassesFlag = false;
                }
            }

            if (addClassesFlag) {
                ul.classList.add("grid");
                ul.classList.add("grid-xxl-2");
            }
        });

        return htmlDoc.querySelector('body').innerHTML;
    }
}

export default ContentFilter;
