import SenzuImporter from "../SenzuImporter.js";
import ImageManagerState from "../../image-manager/ImageManagerState.js";

class FeaturedImage {
	/**
	 * When the set featured image button is clicked
	 * @param id
	 * @returns {Promise<void>}
	 */
	async setImageButtonClicked(id){
		if (SenzuImporter.imageManager !== null) {
			const imageManager = SenzuImporter.imageManager;
			// Open the image manager in select mode
			imageManager.imageManagerState.setImageMode(imageManager.imageManagerState.IMAGE_MODES.SELECT);
			imageManager.windowManager.show(imageManager.windowManager.constructor.WINDOWS.MAIN);
			this.onImageManagerImageSelected(id, await imageManager.imagesChosen);
		}
	}

	/**
	 * When an image is selected from the image manager
	 * @param imageComponentsChosen
	 * @param id
	 */
	onImageManagerImageSelected(id, imageComponentsChosen){
		// Only use the first one
		if (imageComponentsChosen !== null){
			if (imageComponentsChosen.length > 0){
				const firstImageComponent = imageComponentsChosen[0];

				// Some images don't have thumbs
				let thumbURI = firstImageComponent.thumbURI;
				if (thumbURI === null){
					thumbURI = firstImageComponent.uri;
				}

				document.querySelector("#featured-image-" + id).setAttribute("src", thumbURI);
				document.querySelector("#featured-image-" + id).dispatchEvent(new InputEvent("input"));

				document.querySelector("#featured-image-uri-input-" + id).value = firstImageComponent.uri;
				document.querySelector("#featured-image-uri-input-" + id).dispatchEvent(new InputEvent("input"));

				document.querySelector("#featured-image-thumb-uri-input-" + id).value = thumbURI;
				document.querySelector("#featured-image-thumb-uri-input-" + id).dispatchEvent(new InputEvent("input"));
			}
		}
		SenzuImporter.imageManager.windowManager.closeImageManager();
	}

	/**
	 * @param id
	 */
	clearFeaturedImage(id){
		document.querySelector("#featured-image-" + id).setAttribute("src", "");
		document.querySelector("#featured-image-uri-input-" + id).value = "";
		document.querySelector("#featured-image-thumb-uri-input-" + id).value = "";
	}
}

export default new FeaturedImage();