import BSPaginator from "../utils/BSPaginator.js";
import RestorationRow from "./components/RestorationRow.js";
import QueryForm from "./forms/QueryForm.js";

class PageRestoration{

	/** @type {BSPaginator[]} */
	paginators = [];

	isProcessing = false;
	loader = document.querySelector("#loader");
	noResults = document.querySelector("#no-results");
	pageTable = document.querySelector("#page-restoration-table");

	constructor() {
		for (const paginatorElement of document.querySelectorAll(".paginator-container")){

			const paginator = new BSPaginator(paginatorElement);

			paginator.onPageNumberFormSubmitted(newPage => {
				const fData = new FormData(QueryForm.form);
				this.loadRows(newPage, fData.get("query"));
			});

			paginator.onNextButtonClicked(newPage => {
				const fData = new FormData(QueryForm.form);
				this.loadRows(newPage, fData.get("query"));
			});

			paginator.onPrevButtonClicked(newPage => {
				const fData = new FormData(QueryForm.form);
				this.loadRows(newPage, fData.get("query"));
			});

			this.paginators.push(paginator);
		}

		this.loadRows(1, "");
	}

	async loadRows(pageNumber, query){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.loader.style.display = null;
		this.noResults.style.display = "none";
		this.pageTable.style.display = "none";
		RestorationRow.container.innerHTML = "";

		const queryParams = new URLSearchParams();
		queryParams.set("pageNumber", pageNumber);
		queryParams.set("query", query);

		const response = await fetch(`/uplift/deleted-page-restoration/pages?${queryParams.toString()}`, {
		    body:null,
		    method:"GET",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string, totalPages: int, pageArchives: Object[]}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			this.loader.style.display = "none";
		    return;
		}

		if (data.status === 1){
			if (data.pageArchives.length === 0){
				this.noResults.style.display = null;
			}else{
				for (const pageArchive of data.pageArchives){
					const row = new RestorationRow(
						pageArchive.id,
						pageArchive.pageID,
						pageArchive.pageName,
						pageArchive.creationTime
					);

					row.render();
				}

				for (const paginator of this.paginators){
					paginator.setMaxPages(data.totalPages);
				}

				this.pageTable.style.display = null;
			}
		}else if (data.status === -1){

		}

		this.isProcessing = false;
		this.loader.style.display = "none";
	}
}

export default new PageRestoration();