import Scheduler from "../../utils/Scheduler.js";
import AttributeQueryForm from "./AttributeQueryForm.js";
import ManagePageAttributes from "../ManagePageAttributes.js";

class NewAttributeForm{
	isProcessing = false;
	form = document.querySelector("#new-page-attribute-form");
	loader = document.querySelector("#new-attribute-loader");

	constructor() {
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	clearForm(){
		for (const checkbox of document.querySelectorAll(".page-type-checkbox")){
			checkbox.checked = false;
		}

		document.querySelector("#new-attribute-name-input").value = "";
	}

	getPayload(){
		const payload = {
			name: "",
			pageTypes: []
		};

		const fData = new FormData(this.form);
		payload.name = fData.get("name");

		const pageTypeCheckboxes = document.querySelectorAll(".page-type-checkbox");

		for (const pageTypeCheckbox of pageTypeCheckboxes){
			if (pageTypeCheckbox.checked) {
				payload.pageTypes.push(pageTypeCheckbox.getAttribute("data-page-type"));
			}
		}

		return payload;
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.loader.style.display = null;
		this.form.style.display = "none";

		const headers = new Headers();
		headers.set("content-type", "application/json; charset=utf-8");

		const response = await fetch("/uplift/page-attributes/attribute", {
		    body:JSON.stringify(this.getPayload()),
		    method:"PUT",
		    cache:"no-cache",
		    credentials:"same-origin",
			headers: headers
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			this.loader.style.display = "none";
			this.form.style.display = null;
		    return;
		}

		await Scheduler.wait(500);

		if (data.status === 1){
			this.clearForm();
			AttributeQueryForm.setQueryInput("");
			AttributeQueryForm.pageNumber = 1;
			ManagePageAttributes.queryAttributes("", 1);
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.loader.style.display = "none";
		this.form.style.display = null;
	}
}

export default new NewAttributeForm();