import Scheduler from "../../utils/Scheduler.js";
import ManagePageAttributes from "../ManagePageAttributes.js";
import AttributeQueryForm from "./AttributeQueryForm.js";

class EditAttributeForm{
	isProcessing = false;
	form = document.querySelector("#edit-page-attribute-form");
	loader = document.querySelector("#edit-attribute-loader");
	modal = document.querySelector("#edit-attribute-modal");
	bsModal = bootstrap.Modal.getOrCreateInstance(this.modal);
	attributeID = null;

	constructor() {
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	setName(name){
		document.querySelector("#edit-attribute-name-input").value = name;
	}

	/**
	 * @param {Object[]} pageTypes
	 */
	setActivePageTypes(pageTypes){
		for (const pageTypeCheckbox of document.querySelectorAll(".edit-page-type-checkbox")){
			pageTypeCheckbox.checked = false;
		}

		for (/** @type {{id: int, pageAttributeID: string, pageType: string}} */ const pageTypeObject of pageTypes){
			const checkbox = document.querySelector(`.edit-page-type-checkbox[data-page-type="${pageTypeObject.pageType}"]`);
			checkbox.checked = true;
		}
	}

	getPayload(){
		const payload = {
			name: "",
			pageTypes: []
		};

		const fData = new FormData(this.form);
		payload.name = fData.get("name");

		const pageTypeCheckboxes = document.querySelectorAll(".edit-page-type-checkbox");

		for (const pageTypeCheckbox of pageTypeCheckboxes){
			if (pageTypeCheckbox.checked) {
				payload.pageTypes.push(pageTypeCheckbox.getAttribute("data-page-type"));
			}
		}

		return payload;
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.loader.style.display = null;
		this.form.style.display = "none";

		const headers = new Headers();
		headers.set("content-type", "application/json; charset=utf-8");

		const response = await fetch(`/uplift/page-attributes/attribute/${this.attributeID}`, {
		    body:JSON.stringify(this.getPayload()),
		    method:"PATCH",
		    cache:"no-cache",
		    credentials:"same-origin",
			headers: headers
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			this.loader.style.display = "none";
			this.form.style.display = null;
		    return;
		}

		await Scheduler.wait(500);

		if (data.status === 1){
			this.bsModal.hide();
			AttributeQueryForm.setQueryInput("");
			AttributeQueryForm.pageNumber = 1;
			ManagePageAttributes.queryAttributes("", 1);
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.loader.style.display = "none";
		this.form.style.display = null;
	}
}

export default new EditAttributeForm();