import ManagePageAttributes from "../ManagePageAttributes.js";

class FORM_COMPONENT{
	isProcessing = false;
	form = document.querySelector("#page-attributes-query-form");
	pageNumber = 1;

	constructor() {
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	setQueryInput(query){
		document.querySelector("#attribute-query-input").value = query;
	}

	getQueryInput(){
		const fData = new FormData(this.form);
		return fData.get("query");
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		await ManagePageAttributes.queryAttributes(this.getQueryInput(), 1);

		this.isProcessing = false;
	}
}

export default new FORM_COMPONENT();