import EditAttributeForm from "../forms/EditAttributeForm.js";
import ConfirmModal from "../../utils/ConfirmModal.js";
import ManagePageAttributes from "../ManagePageAttributes.js";

class PageAttribute{

	/** @type {PageAttribute[]} */
	static cache = [];
	static container = document.querySelector("#results-container");

	id;
	dom;
	name;
	pageTypesArray;

	constructor(id, name, pageTypesArray) {
		this.id = id;
		this.name = name;
		this.pageTypesArray = pageTypesArray;
		this.dom = this.getDOM();
		this.constructor.cache.push(this);
	}

	render(){
		PageAttribute.container.append(this.dom);
	}

	async onDeleteButtonClicked(){
		const confirmModal = new ConfirmModal("delete-page-attribute-confirm-modal");
		confirmModal.setConfirmButtonHTML("Delete");
		confirmModal.setContent("Are you sure you want to delete this attribute? All values pages have that are linked to this attribute will also be removed.");
		confirmModal.setTitle("Confirm Deletion of Page Attribute");
		confirmModal.showModal();
		const didConfirm = await confirmModal.actionTaken();
		if (didConfirm){
			await fetch(`/uplift/page-attributes/attribute/${this.id}`, {
				method: "DELETE",
				cache: "no-cache",
				credentials:"same-origin"
			});

			confirmModal.cleanup();
			ManagePageAttributes.reloadCurrentAttributeQuery();
		}
	}

	getDOM(){
		const template = document.createElement("tr");
		let pageTypesAsString = "";

		/** @param {{id: int, pageAttributeID: string, pageType: string}} pageTypeObject */
		for (const [index, pageTypeObject] of this.pageTypesArray.entries()){
			if (index < this.pageTypesArray.length - 1) {
				pageTypesAsString += `${pageTypeObject.pageType}, `;
			}else{
				pageTypesAsString += pageTypeObject.pageType;
			}
		}

		template.classList.add("page-attribute");
		template.classList.add("page-attribute-columns");
		template.innerHTML = `
			<td class="id-column">
				${this.id}
			</td>
			<td class="name-column">
				${this.name}
			</td>
			<td class="page-types-column">
				${pageTypesAsString}
			</td>
			<td class="edit-column text-end">
				<button type="button" class="edit-button btn btn-primary">
					<i class="bi bi-pencil-square"></i>
					<span>Edit</span>
				</button>
				<button type="button" class="delete-button btn btn-danger">
					<i class="bi bi-x-square-fill"></i>
					<span>Delete</span>
				</button>
			</td>
		`;

		const editButton = template.querySelector(".edit-button");
		const deleteButton = template.querySelector(".delete-button");


		editButton.addEventListener("click", () => {
			EditAttributeForm.attributeID = this.id;
			EditAttributeForm.setName(this.name);
			EditAttributeForm.setActivePageTypes(this.pageTypesArray);
			EditAttributeForm.bsModal.show();
		});

		deleteButton.addEventListener("click", () => {
			this.onDeleteButtonClicked();
		});

		return template;
	}
}

export default PageAttribute;