import Endpoints from "../../Endpoints.js";
import NewSitemapModal from "../modals/NewSitemapModal.js";
import SitemapManager from "../SitemapManager.js";

class NewSitemapForm{
	constructor(){
		this.isProcessing = false;
		this.form = document.querySelector("#new-sitemap-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		NewSitemapModal.errorContainer.style.display = "none";

		const fData = new FormData(this.form);

		// Send the new sitemap content from the "new sitemap" ace editor
		fData.set("content", SitemapManager.newSitemapAceEditor.session.getValue());

		const response = await fetch(Endpoints.sitemapManager.newSitemap, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"PUT"
		});

		let data;
		try{
			data = await response.json();
		}catch(jsonSyntaxError){
			NewSitemapModal.errorContainer.style.display = "block";
			NewSitemapModal.errorMessageContainer.textContent = "The server sent back invalid JSON.";
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			// Reload all sitemaps
			SitemapManager.loadSitemaps();

			NewSitemapModal.hideModal();
			this.form.reset();
		}else if (data.status === -1){
			NewSitemapModal.errorContainer.style.display = "block";
			NewSitemapModal.errorMessageContainer.textContent = data.error;
		}

		this.isProcessing = false;
	}
}

export default new NewSitemapForm();