class Role{
	static rolesContainer = document.querySelector("#roles-rows-container");

	constructor(id, name, canBeDeleted, timestamp) {
		this.id = id;
		this.name = name;
		this.canBeDeleted = canBeDeleted;
		this.timestamp = timestamp;
		this.dom = this.getDOM();

		Role.rolesContainer.append(this.dom);
	}

	getDOM(){
		const template = document.createElement("role-row");
		const dateString = (new Date(this.timestamp * 1000)).toLocaleDateString();

		template.classList.add("roles-columns");

		template.innerHTML = `
			<div class="name">
				<span>${this.name}</span>
			</div>
			<div class="date-created">
				<span>${dateString}</span>
			</div>
			<div class="management-button">
				<a href="/uplift/manage-roles/${this.id}" class="btn btn-sm btn-primary">
					<i class="bi bi-wrench"></i>
					<span>Manage</span>
				</a>
			</div>
		`;

		return template;
	}
}

export default Role;