import Endpoints from "../Endpoints.js";
import NewRoleForm from "./forms/NewRoleForm.js";
import NewRoleModal from "./modals/NewRoleModal.js";
import Role from "./components/Role.js";
import Scheduler from "../utils/Scheduler.js";

class Roles {
	loaderElement = document.querySelector("#roles-loader");

	constructor() {
		(async () => {
			this.loadRoles();
		})();
	}

	async loadRoles(){
		// Clear current roles
		Role.rolesContainer.innerHTML = "";

		// Show loader
		this.loaderElement.style.display = "block";

		const response = await fetch(`${Endpoints.roles.getRoles}`, {
			body:null,
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data;
		try{
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
		}

		// Force-wait a minimum of 0.15s so things don't flash
		await Scheduler.wait(150);

		// Hide loader
		this.loaderElement.style.display = "none";
		
		if (data.status === 1){
			for (const role of data.roles){
				new Role(
					role.id,
					role.name,
					role.canBeDeleted,
					role.timestamp,
				);
			}
		}else if (data.status === -1){
			console.log("Something went wrong.");
		}
	}
}

export default new Roles();