import EditRoleForm from "./forms/EditRoleForm.js";
import DeleteRoleModal from "./modals/DeleteRoleModal.js";
import HasAllPermsCheckbox from "./components/HasAllPermsCheckbox.js";

class ManageRole {
	constructor(){
		window.addEventListener("keydown", e => {
			if (e.ctrlKey){
				if (e.key === "s"){
					e.preventDefault();
					this.onSaveShortcut();
				}
			}
		});

		document.querySelector("#delete-role-button").addEventListener("click", e => {
			this.onDelete();
		});
	}

	/**
	 * When the user performs ctrl+s or cmd+s
	 */
	onSaveShortcut(){
		// Manually fire the forms submit
		EditRoleForm.onSubmit()
	}

	/**
	 * When the delete button is clicked
	 */
	async onDelete(){
		await EditRoleForm.onDelete();
	}
}

export default new ManageRole();