import BSModal from "../../_external/bootstrap/modal.js";
import RatingStars from "../components/RatingStars.js";

class NewReviewModal{
	constructor(){
		this.modal = document.querySelector("#new-review-modal");
		this.triggerButton = document.querySelector("#new-review-modal-trigger-button");
		this.errorContainer = this.modal.querySelector("#new-review-modal-error");
		this.errorMessageContainer = this.errorContainer.querySelector(".bg-danger");
		this.ratingInput = document.querySelector("#new-review-rating");
		this.bsModal = new BSModal(this.modal);

		this.triggerButton.addEventListener("click", () => {
			this.showModal();
		});

		const ratingStars = new RatingStars(document.querySelector("#new-review-rating-stars"));

		// Set the rating input value when a star is selected
		ratingStars.onStarSelected(rating => {
			this.ratingInput.value = String(rating);
		});

		this.ratingInput.value = String(5);
		ratingStars.highlightToRating(5);
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}
}

export default new NewReviewModal();
