import Endpoints from "../../Endpoints.js";
import NewReviewModal from "../modals/NewReviewModal.js";
import ManageReviews from "../ManageReviews.js";

class NewReviewForm{
	constructor(){
		this.isProcessing = false;
		this.form = document.querySelector("#new-review-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		NewReviewModal.errorContainer.style.display = "none";

		const fData = new FormData(this.form);

		const response = await fetch(Endpoints.reviews.newReview, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"PUT"
		});

		let data;
		try{
		    data = await response.json();
		}catch(jsonSyntaxError){
			NewReviewModal.errorContainer.style.display = "block";
			NewReviewModal.errorMessageContainer.textContent = "The server sent back invalid JSON.";
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			// Reload all reviews
			ManageReviews.currentPage = ManageReviews.constructor.DEFAULT_PAGE;
			ManageReviews.currentLimit = ManageReviews.constructor.DEFAULT_LIMIT;
			ManageReviews.currentQuery = "";
			ManageReviews.loadReviews(
				ManageReviews.currentPage,
				ManageReviews.currentLimit,
				ManageReviews.currentQuery
			);

			NewReviewModal.hideModal();
			this.form.reset();
		}else if (data.status === -1){
			NewReviewModal.errorContainer.style.display = "block";
			NewReviewModal.errorMessageContainer.textContent = data.error;
		}

		this.isProcessing = false;
	}
}

export default new NewReviewForm();