import Endpoints from "../../Endpoints.js";
import EditReviewModal from "../modals/EditReviewModal.js";
import ManageReviews from "../ManageReviews.js";

class EditReviewForm{
	constructor(){
		this.isProcessing = false;
		this.form = document.querySelector("#edit-review-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		EditReviewModal.errorContainer.style.display = "none";

		const fData = new FormData(this.form);

		const response = await fetch(`${Endpoints.reviews.editReview}/${EditReviewModal.currentReviewID}`, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"PATCH"
		});

		let data;
		try{
		    data = await response.json();
		}catch(jsonSyntaxError){
			EditReviewModal.errorContainer.style.display = "block";
			EditReviewModal.errorMessageContainer.textContent = "The server sent back invalid JSON.";
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			// Reload the current reviews page to reflect the changes
			ManageReviews.loadReviews(
				ManageReviews.currentPage,
				ManageReviews.currentLimit,
				ManageReviews.currentQuery
			);

			EditReviewModal.hideModal();
			this.form.reset();
		}else if (data.status === -1){
			EditReviewModal.errorContainer.style.display = "block";
			EditReviewModal.errorMessageContainer.textContent = data.error;
		}

		this.isProcessing = false;
	}
}

export default new EditReviewForm();