class RatingStars{
	/**
	 * @param {HTMLDivElement} parentElement
	 */
	constructor(parentElement) {
		this.eventListeners = [];
		this.stars = Array.from(parentElement.querySelectorAll("i"));
		this.parentElement = parentElement;
		parentElement.setAttribute("rating", "0");

		for (const star of this.stars){

			star.addEventListener("mouseover", e => {
				e.stopPropagation();
				this.onStarHovered(star);
			});

			star.addEventListener("click", () => {
				parentElement.setAttribute("rating", String(this.stars.indexOf(star) + 1));
				for (const callback of this.eventListeners){
					// Fire the event listener callbacks
					callback(this.stars.indexOf(star) + 1);
				}
			});
		}

		parentElement.addEventListener("mouseleave", () => {
			this.highlightToRating(parentElement.getAttribute("rating"));
		});
	}

	highlightToRating(rating){
		// Remove color from all stars
		for (const star of this.stars){
			if (star.classList.contains("colored")){
				star.classList.remove("colored");
			}
		}

		if (rating > 0) {
			let currentStar = this.stars[rating - 1];
			// Color current star and previous ones
			do{
				currentStar.classList.add("colored");
				currentStar = currentStar.previousElementSibling;
			}while(currentStar !== null);
		}
	}

	/**
	 * When the mouse goes over a star
	 * @param {HTMLElement} currentStar
	 */
	onStarHovered(currentStar){
		this.highlightToRating(this.stars.indexOf(currentStar) + 1);
	}

	onStarSelected(callback){
		this.eventListeners.push(callback);
	}
}

export default RatingStars;