import ManageRedirects from "../ManageRedirects.js";

class SearchRedirectsForm{
	constructor(){
		this.isProcessing = false;
		this.form = document.querySelector("#redirect-search-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const fData = new FormData(this.form);
		const query = fData.get("query");

		ManageRedirects.currentPage = 1;
		ManageRedirects.currentQuery = query;
		await ManageRedirects.loadRedirects(
			ManageRedirects.currentPage,
			ManageRedirects.currentLimit,
			ManageRedirects.currentQuery
		);

		this.isProcessing = false;
	}
}

export default new SearchRedirectsForm();