import Endpoints from "../../Endpoints.js";
import ApacheManager from "../ApacheManager.js";

class EditHtaccessForm {
	form = document.querySelector("#htaccess-form");
	submitButton = document.querySelector(`button[type="submit"]`);
	isProcessing = false;

	constructor() {
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit() {
		if(this.isProcessing) {
			return;
		}

		this.isProcessing = true;
		this.submitButton.classList.add("disabled");

		const fData = new FormData(this.form);
		// Send the new content from the "edit htaccess" ace editor
		fData.set("htaccess-content", ApacheManager.htaccessAceEditor.session.getValue());

		const response = await fetch(`${Endpoints.apacheManager.editHtaccess}`, {
			body:fData,
			cache:"no-cache",
			credentials:"same-origin",
			method:"PATCH"
		});

		let data;

		try{
			/** @type {{status: int, error: ?string}} */
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			this.submitButton.classList.remove("disabled");
			return;
		}

		if (data.status === 1){

		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.submitButton.classList.remove("disabled");
	}
}

export default new EditHtaccessForm();