import AceEditorExtension from "../editors/AceEditorExtension.js";
import EditHtaccessForm from "./forms/EditHtaccessForm.js";
import Endpoints from "../Endpoints.js";

class ApacheManager {
	htaccessAceContainer = document.querySelector("#htaccess-content-editor");
	htaccessAceEditor = ace.edit(this.htaccessAceContainer);
	isProcessing = false;
	loader = document.querySelector("#htaccess-loader");

	constructor() {
		// Load the ace editor
		new AceEditorExtension(this.htaccessAceContainer, "apache_conf");

		this.loadHtaccess();
	}

	async loadHtaccess() {
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.loader.style.display = "block";

		const response = await fetch(`${Endpoints.apacheManager.getHtaccess}`, {
			cache:"no-cache",
			credentials:"same-origin",
			method:"get",
		});

		let data;
		try{
			/** @type {{status: int, error: ?string, htaccess: Object[]}} **/
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			return;
		}

		this.loader.style.display = "none";

		if (data.status === 1){
			this.htaccessAceEditor.session.setValue(data.htaccess);
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new ApacheManager();