import ImageManager from "../ImageManager.js";
import SelectionListener from "../SelectionListener.js";

class SelectImagesButton{
	/**
	 * @type {?ImageManager}
	 */
	imageManager = null;

	/**
	 * @param {ImageManager} imageManager
	 */
	constructor(imageManager){
		this.imageManager = imageManager;
		this.button = document.querySelector("#im-select-image-button");

		this.button.addEventListener("click", () => {
			this.onButtonClicked();
		});
	}

	onButtonClicked(){
		this.imageManager.fireImagesSelected(this.imageManager.selectionListener.currentImageComponentSelection);
	}
}

export default SelectImagesButton;